<?php
/**
 * Defines SOAP class mapping metadata in the ViaClassmap class.
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via;

/**
 * Defines the class mapping for SOAP result types into the VIA API classes. The SOAP client will use these class
 * mappings to create responses of the expected type. You can customise API response behaviour by extending the classes
 * supplied with the wrapper and passing in your own classmap to the VIA client.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here. Instead merge your custom mapping on top of the values provided here.
 *
 * @see        \Red61\Via\ApiClient.
 */
class ViaClassmap {

	/**
	 * @var string[]  keys are the SOAP class, values are the fully qualified PHP type
	 */
	public static $dataClassmap = array (
  'viaApiAddressDetails' => '\\Red61\\Via\\DataObject\\ViaApiAddressDetails',
  'viaApiAddressResult' => '\\Red61\\Via\\DataObject\\ViaApiAddressResult',
  'viaApiAnswer' => '\\Red61\\Via\\DataObject\\ViaApiAnswer',
  'viaApiBasket' => '\\Red61\\Via\\DataObject\\ViaApiBasket',
  'viaApiBasketEventItem' => '\\Red61\\Via\\DataObject\\ViaApiBasketEventItem',
  'viaApiBasketFeeDetails' => '\\Red61\\Via\\DataObject\\ViaApiBasketFeeDetails',
  'viaApiBasketLimits' => '\\Red61\\Via\\DataObject\\ViaApiBasketLimits',
  'viaApiBasketPerformanceItem' => '\\Red61\\Via\\DataObject\\ViaApiBasketPerformanceItem',
  'viaApiBasketSubVenueItem' => '\\Red61\\Via\\DataObject\\ViaApiBasketSubVenueItem',
  'viaApiBasketSummary' => '\\Red61\\Via\\DataObject\\ViaApiBasketSummary',
  'viaApiBasketVenueItem' => '\\Red61\\Via\\DataObject\\ViaApiBasketVenueItem',
  'viaApiCardType' => '\\Red61\\Via\\DataObject\\ViaApiCardType',
  'viaApiCompany' => '\\Red61\\Via\\DataObject\\ViaApiCompany',
  'viaApiCountryDetails' => '\\Red61\\Via\\DataObject\\ViaApiCountryDetails',
  'viaApiCustomCustomerFieldChoiceDetails' => '\\Red61\\Via\\DataObject\\ViaApiCustomCustomerFieldChoiceDetails',
  'viaApiCustomCustomerFieldDetails' => '\\Red61\\Via\\DataObject\\ViaApiCustomCustomerFieldDetails',
  'viaApiCustomEventDetails' => '\\Red61\\Via\\DataObject\\ViaApiCustomEventDetails',
  'viaApiCustomerCategory' => '\\Red61\\Via\\DataObject\\ViaApiCustomerCategory',
  'viaApiCustomerCompanyResponse' => '\\Red61\\Via\\DataObject\\ViaApiCustomerCompanyResponse',
  'viaApiCustomerDetails' => '\\Red61\\Via\\DataObject\\ViaApiCustomerDetails',
  'viaApiCustomerEventInterest' => '\\Red61\\Via\\DataObject\\ViaApiCustomerEventInterest',
  'viaApiCustomerOtherDetails' => '\\Red61\\Via\\DataObject\\ViaApiCustomerOtherDetails',
  'viaApiCustomerPerformanceInterest' => '\\Red61\\Via\\DataObject\\ViaApiCustomerPerformanceInterest',
  'viaApiDonationBasketItem' => '\\Red61\\Via\\DataObject\\ViaApiDonationBasketItem',
  'viaApiDonationDetails' => '\\Red61\\Via\\DataObject\\ViaApiDonationDetails',
  'viaApiDonationFund' => '\\Red61\\Via\\DataObject\\ViaApiDonationFund',
  'viaApiEvent' => '\\Red61\\Via\\DataObject\\ViaApiEvent',
  'viaApiEventPerformance' => '\\Red61\\Via\\DataObject\\ViaApiEventPerformance',
  'viaApiFeeDetails' => '\\Red61\\Via\\DataObject\\ViaApiFeeDetails',
  'viaApiFeeItemDetails' => '\\Red61\\Via\\DataObject\\ViaApiFeeItemDetails',
  'viaApiGiftAidDeclarationDetails' => '\\Red61\\Via\\DataObject\\ViaApiGiftAidDeclarationDetails',
  'viaApiHPHPerformance' => '\\Red61\\Via\\DataObject\\ViaApiHPHPerformance',
  'viaApiImage' => '\\Red61\\Via\\DataObject\\ViaApiImage',
  'viaApiListElement' => '\\Red61\\Via\\DataObject\\ViaApiListElement',
  'viaApiListValue' => '\\Red61\\Via\\DataObject\\ViaApiListValue',
  'viaApiMerchandise' => '\\Red61\\Via\\DataObject\\ViaApiMerchandise',
  'viaApiMerchandiseBasketItem' => '\\Red61\\Via\\DataObject\\ViaApiMerchandiseBasketItem',
  'viaApiMerchandiseCategory' => '\\Red61\\Via\\DataObject\\ViaApiMerchandiseCategory',
  'viaApiMerchandiseDetails' => '\\Red61\\Via\\DataObject\\ViaApiMerchandiseDetails',
  'viaApiMerchandiseVariation' => '\\Red61\\Via\\DataObject\\ViaApiMerchandiseVariation',
  'viaApiOrderDetails' => '\\Red61\\Via\\DataObject\\ViaApiOrderDetails',
  'viaApiPerformance' => '\\Red61\\Via\\DataObject\\ViaApiPerformance',
  'viaApiPerformanceAvailability' => '\\Red61\\Via\\DataObject\\ViaApiPerformanceAvailability',
  'viaApiPerformanceConcession' => '\\Red61\\Via\\DataObject\\ViaApiPerformanceConcession',
  'viaApiPerformancePrice' => '\\Red61\\Via\\DataObject\\ViaApiPerformancePrice',
  'viaApiPerformancePrices' => '\\Red61\\Via\\DataObject\\ViaApiPerformancePrices',
  'viaApiPostageCharge' => '\\Red61\\Via\\DataObject\\ViaApiPostageCharge',
  'viaApiPriceBandAvailibility' => '\\Red61\\Via\\DataObject\\ViaApiPriceBandAvailibility',
  'viaApiPriceConcession' => '\\Red61\\Via\\DataObject\\ViaApiPriceConcession',
  'viaApiProductDetails' => '\\Red61\\Via\\DataObject\\ViaApiProductDetails',
  'viaApiPurchaseSummary' => '\\Red61\\Via\\DataObject\\ViaApiPurchaseSummary',
  'viaApiQuestion' => '\\Red61\\Via\\DataObject\\ViaApiQuestion',
  'viaApiQuestionResponse' => '\\Red61\\Via\\DataObject\\ViaApiQuestionResponse',
  'viaApiQuestionnaire' => '\\Red61\\Via\\DataObject\\ViaApiQuestionnaire',
  'viaApiSavedCardDetails' => '\\Red61\\Via\\DataObject\\ViaApiSavedCardDetails',
  'viaApiSchemeDetails' => '\\Red61\\Via\\DataObject\\ViaApiSchemeDetails',
  'viaApiSchemeTierConcessionDetails' => '\\Red61\\Via\\DataObject\\ViaApiSchemeTierConcessionDetails',
  'viaApiSchemeTierDetails' => '\\Red61\\Via\\DataObject\\ViaApiSchemeTierDetails',
  'viaApiSeasonDetails' => '\\Red61\\Via\\DataObject\\ViaApiSeasonDetails',
  'viaApiSeatDetails' => '\\Red61\\Via\\DataObject\\ViaApiSeatDetails',
  'viaApiSubVenueDetails' => '\\Red61\\Via\\DataObject\\ViaApiSubVenueDetails',
  'viaApiSubscriptionBasketItem' => '\\Red61\\Via\\DataObject\\ViaApiSubscriptionBasketItem',
  'viaApiSubscriptionDetails' => '\\Red61\\Via\\DataObject\\ViaApiSubscriptionDetails',
  'viaApiTicketDetails' => '\\Red61\\Via\\DataObject\\ViaApiTicketDetails',
  'viaApiTicketItemDetails' => '\\Red61\\Via\\DataObject\\ViaApiTicketItemDetails',
  'viaApiTicketRequest' => '\\Red61\\Via\\DataObject\\ViaApiTicketRequest',
  'viaApiTransactionEventFeeDetails' => '\\Red61\\Via\\DataObject\\ViaApiTransactionEventFeeDetails',
  'viaApiTransactionFeeDetails' => '\\Red61\\Via\\DataObject\\ViaApiTransactionFeeDetails',
  'viaApiTransactionSummary' => '\\Red61\\Via\\DataObject\\ViaApiTransactionSummary',
  'viaApiTypeListElement' => '\\Red61\\Via\\DataObject\\ViaApiTypeListElement',
  'viaApiVenueDetails' => '\\Red61\\Via\\DataObject\\ViaApiVenueDetails',
  'viaApiVoucherDetails' => '\\Red61\\Via\\DataObject\\ViaApiVoucherDetails',
  'viaApiVoucherRedeemBasketItem' => '\\Red61\\Via\\DataObject\\ViaApiVoucherRedeemBasketItem',
  'viaApiVoucherType' => '\\Red61\\Via\\DataObject\\ViaApiVoucherType',
  'viaApiVoucherTypeBasketItem' => '\\Red61\\Via\\DataObject\\ViaApiVoucherTypeBasketItem',
);

	/**
	 * @var string[]  keys are the SOAP class, values are the fully qualified PHP type
	 */
	public static $exceptionClassmap = array (
  'AddSeatsException' => '\\Red61\\Via\\Exception\\AddSeatsException',
  'BasketChangedException' => '\\Red61\\Via\\Exception\\BasketChangedException',
  'CartNotFoundException' => '\\Red61\\Via\\Exception\\CartNotFoundException',
  'CustomerMergedException' => '\\Red61\\Via\\Exception\\CustomerMergedException',
  'DuplicateRecordException' => '\\Red61\\Via\\Exception\\DuplicateRecordException',
  'EJBException' => '\\Red61\\Via\\Exception\\EJBException',
  'GiftAidDeclarationOverlapException' => '\\Red61\\Via\\Exception\\GiftAidDeclarationOverlapException',
  'IllegalArgumentException' => '\\Red61\\Via\\Exception\\IllegalArgumentException',
  'IllegalGiftAidException' => '\\Red61\\Via\\Exception\\IllegalGiftAidException',
  'InvalidTokenException' => '\\Red61\\Via\\Exception\\InvalidTokenException',
  'NoResultsException' => '\\Red61\\Via\\Exception\\NoResultsException',
  'TooManyCartsException' => '\\Red61\\Via\\Exception\\TooManyCartsException',
  'ViaApiOrderFailException' => '\\Red61\\Via\\Exception\\ViaApiOrderFailException',
  '_generic' => '\\Red61\\Via\\Exception\\ViaSoapFault',
);

}
