<?php
/**
 * Defines the RawapiSetCustomerFriendStatusRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Sets the customers friend status
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSetCustomerFriendStatusRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSetCustomerFriendStatusRequest.
 */
abstract class RawapiSetCustomerFriendStatusRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiSetCustomerFriendStatus';

  /**
   * The id of the customer to set the friend status of.
   *
   * @var int
   */
  protected $customerId;

  /**
   * boolean indicating friend status
   *
   * @var bool
   */
  protected $friend;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the customer to set the friend status of.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer to set the friend status of.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * boolean indicating friend status
   *
   * @return bool
   */
  public function getFriend()
  {
    return $this->friend;
  }


  /**
   * boolean indicating friend status
   *
   * @param bool $friend
   *
   * @return $this
   */
  public function setFriend($friend)
  {
    $this->friend = $friend;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
