<?php
/**
 * Defines the RawapiDeclineQuestionnaireRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Called to indicate that the given customer has declined to answer this questionnaire. This customer wont be prompted
 * with this questionnaire in the future.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiDeclineQuestionnaireRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiDeclineQuestionnaireRequest.
 */
abstract class RawapiDeclineQuestionnaireRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiDeclineQuestionnaire';

  /**
   * The id of the customer declining to answer
   *
   * @var int
   */
  protected $customerId;

  /**
   * The questionnaireRef of the questionnaire being declined in the form "serverId:questionnaireId"
   *
   * @var string
   */
  protected $questionnaireRef;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the customer declining to answer
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer declining to answer
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The questionnaireRef of the questionnaire being declined in the form "serverId:questionnaireId"
   *
   * @return string
   */
  public function getQuestionnaireRef()
  {
    return $this->questionnaireRef;
  }


  /**
   * The questionnaireRef of the questionnaire being declined in the form "serverId:questionnaireId"
   *
   * @param string $questionnaireRef
   *
   * @return $this
   */
  public function setQuestionnaireRef($questionnaireRef)
  {
    $this->questionnaireRef = $questionnaireRef;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
