<?php
/**
 * Defines the ViaApiCustomerCompanyResponse VIA data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\DataObject;

/**
 * @package    Red61\Via\DataObject
 * {@inheritdoc}
 */
class ViaApiCustomerCompanyResponse extends \Red61\Via\RawGenerated\DataObject\RawViaApiCustomerCompanyResponse {


	/**
	 *
	 * @param string $companyId The reference for the Company in the form "serverId:companyId".
	 * @param bool   $response  The response given by the customer to allow this company to contact them. A NULL value indicates that the customer did not provide a response.
	 */
	public function __construct($companyId, $response)
	{
		$this->companyId = $companyId;
		$this->response = $response;
	}
}
