<?php
/**
 * Defines Red61\Via\Cache\ViaCacheKeyGenerator
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace Red61\Via\Cache;
use Red61\Via\ApiRequest\ViaApiRequest;

/**
 * Responsible for producing unique cache keys for API requests
 *
 * @package Red61\Via\Cache
 * @see     spec\Red61\Via\Cache\ViaCacheKeyGeneratorSpec
 */
class ViaCacheKeyGenerator {

	/**
	 * @param ViaApiRequest $request
	 *
	 * @return string
	 */
	public function get_key(ViaApiRequest $request)
	{
		return $request->getSoapMethodName().'('.base64_encode(serialize($request)).')';
	}
}
