<?php
/**
 * Defines the RawViaApiPriceConcession data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores information on a Price Concession
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiPriceConcession.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiPriceConcession.
 */
abstract class RawViaApiPriceConcession {

  /**
   * The code of this price concession.
   *
   * @var string
   */
  protected $code;

  /**
   * The reference for the base concession in the format "serverId:concessionId".
   *
   * @var string
   */
  protected $concessionRef;

  /**
   * The concession title.
   *
   * @var string
   */
  protected $title;

  /**
   * The value of this concession.
   *
   * @var string
   */
  protected $concPrice;

  /**
   * The id of this price concession.
   *
   * @var int
   */
  protected $concessionid;

  /**
   * Return the concession required quantity. This is the amount of tickets that must have the concession before a
   * discount is applied. I.e. for a required quantity of 3 the concession can only be applied to groups of three
   * tickets or more.
   *
   * @var int
   */
  protected $concessionRequiredQty;

  /**
   * The price concession description.
   *
   * @var string
   */
  protected $description;

  /**
   * Whether this is a limited concession.
   *
   * @var bool
   */
  protected $limited;

  /**
   * Whether or not this concession requires the use of a promocode.
   *
   * @var bool
   */
  protected $promoCodeRequired;

  /**
   * Whether or not this concession is gift aidable.
   *
   * @var bool
   */
  protected $isGiftAidable;

  /**
   * The gift aidable value of this concession.
   *
   * @var double
   */
  protected $donationValue;

  /**
   * The value that this concession is limited to if this concession is limited to a certain amount.
   *
   * @var int
   */
  protected $limitValue;

  /**
   * An estimate of the remaining number of applications this concession can have.
   *
   * @var int
   */
  protected $remainingLimitValue;

  /**
   * The Key of the ticket offer relating to this concession in the form serverId:PB:priceBandConcessionId.
   *
   * @var string
   */
  protected $ticketOfferKey;

  /**
   * A List of `ViaApiFeeDetails` objects containing information on the fees that will be applied to tickets purchased
   * for this priceband concession. Note: field is `null` if no fees have been applied
   *
   * @var \Red61\Via\DataObject\ViaApiFeeDetails[]
   */
  protected $fees;

  /**
   * A flag indicating if tickets that get this concession applied will be exempt from any handling fees
   *
   * @var bool
   */
  protected $feeExempt;

  /**
   * Indicates if tickets that get this concession applied will be exempt from any event fees or priceband-level ticket
   * fees
   *
   * @var bool
   */
  protected $eventAndPricebandFeeExempt;

  /**
   * A flag indicating that this concession should be visible to the customer, but not purchasable.
   *
   * @var bool
   */
  protected $listOnly;

  /**
   * A flag indicating that the customer may choose their own price for this ticket type
   *
   * @var bool
   */
  protected $priceOverrideAvailable;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'code':
        return $this->getCode();
      case 'concessionRef':
        return $this->getConcessionRef();
      case 'title':
        return $this->getTitle();
      case 'concPrice':
        return $this->getConcPrice();
      case 'concessionid':
        return $this->getConcessionid();
      case 'concessionRequiredQty':
        return $this->getConcessionRequiredQty();
      case 'description':
        return $this->getDescription();
      case 'limited':
        return $this->getLimited();
      case 'promoCodeRequired':
        return $this->getPromoCodeRequired();
      case 'isGiftAidable':
        return $this->getIsGiftAidable();
      case 'donationValue':
        return $this->getDonationValue();
      case 'limitValue':
        return $this->getLimitValue();
      case 'remainingLimitValue':
        return $this->getRemainingLimitValue();
      case 'ticketOfferKey':
        return $this->getTicketOfferKey();
      case 'fees':
        return $this->getFees();
      case 'feeExempt':
        return $this->getFeeExempt();
      case 'eventAndPricebandFeeExempt':
        return $this->getEventAndPricebandFeeExempt();
      case 'listOnly':
        return $this->getListOnly();
      case 'priceOverrideAvailable':
        return $this->getPriceOverrideAvailable();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The code of this price concession.
   *
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }


  /**
   * The reference for the base concession in the format "serverId:concessionId".
   *
   * @return string
   */
  public function getConcessionRef()
  {
    return $this->concessionRef;
  }


  /**
   * The concession title.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The value of this concession.
   *
   * @return string
   */
  public function getConcPrice()
  {
    return $this->concPrice;
  }


  /**
   * The id of this price concession.
   *
   * @return int
   */
  public function getConcessionid()
  {
    return $this->concessionid;
  }


  /**
   * Return the concession required quantity. This is the amount of tickets that must have the concession before a
   * discount is applied. I.e. for a required quantity of 3 the concession can only be applied to groups of three
   * tickets or more.
   *
   * @return int
   */
  public function getConcessionRequiredQty()
  {
    return $this->concessionRequiredQty;
  }


  /**
   * The price concession description.
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


  /**
   * Whether this is a limited concession.
   *
   * @return bool
   */
  public function getLimited()
  {
    return $this->limited;
  }


  /**
   * Whether or not this concession requires the use of a promocode.
   *
   * @return bool
   */
  public function getPromoCodeRequired()
  {
    return $this->promoCodeRequired;
  }


  /**
   * Whether or not this concession is gift aidable.
   *
   * @return bool
   */
  public function getIsGiftAidable()
  {
    return $this->isGiftAidable;
  }


  /**
   * The gift aidable value of this concession.
   *
   * @return double
   */
  public function getDonationValue()
  {
    return $this->donationValue;
  }


  /**
   * The value that this concession is limited to if this concession is limited to a certain amount.
   *
   * @return int
   */
  public function getLimitValue()
  {
    return $this->limitValue;
  }


  /**
   * An estimate of the remaining number of applications this concession can have.
   *
   * @return int
   */
  public function getRemainingLimitValue()
  {
    return $this->remainingLimitValue;
  }


  /**
   * The Key of the ticket offer relating to this concession in the form serverId:PB:priceBandConcessionId.
   *
   * @return string
   */
  public function getTicketOfferKey()
  {
    return $this->ticketOfferKey;
  }


  /**
   * A List of `ViaApiFeeDetails` objects containing information on the fees that will be applied to tickets purchased
   * for this priceband concession. Note: field is `null` if no fees have been applied
   *
   * @return \Red61\Via\DataObject\ViaApiFeeDetails[]
   */
  public function getFees()
  {
	return $this->fees ? : array();
  }


  /**
   * A flag indicating if tickets that get this concession applied will be exempt from any handling fees
   *
   * @return bool
   */
  public function getFeeExempt()
  {
    return $this->feeExempt;
  }


  /**
   * Indicates if tickets that get this concession applied will be exempt from any event fees or priceband-level ticket
   * fees
   *
   * @return bool
   */
  public function getEventAndPricebandFeeExempt()
  {
    return $this->eventAndPricebandFeeExempt;
  }


  /**
   * A flag indicating that this concession should be visible to the customer, but not purchasable.
   *
   * @return bool
   */
  public function getListOnly()
  {
    return $this->listOnly;
  }


  /**
   * A flag indicating that the customer may choose their own price for this ticket type
   *
   * @return bool
   */
  public function getPriceOverrideAvailable()
  {
    return $this->priceOverrideAvailable;
  }


}
