<?php
/**
 * Defines the RawapiRemoveCustomerCategoryRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Remove a category from the given customer.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiRemoveCustomerCategoryRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiRemoveCustomerCategoryRequest.
 */
abstract class RawapiRemoveCustomerCategoryRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiRemoveCustomerCategory';

  /**
   * The id of the customer
   *
   * @var int
   */
  protected $customerId;

  /**
   * The id of the category to remove. This must correspond to web accessible customer categories ids.
   *
   * @var int
   */
  protected $categoryId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the customer
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The id of the category to remove. This must correspond to web accessible customer categories ids.
   *
   * @return int
   */
  public function getCategoryId()
  {
    return $this->categoryId;
  }


  /**
   * The id of the category to remove. This must correspond to web accessible customer categories ids.
   *
   * @param int $categoryId
   *
   * @return $this
   */
  public function setCategoryId($categoryId)
  {
    $this->categoryId = $categoryId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
