<?php
/**
 * Defines the RawBadCustomerException base exception class
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\Exception;

use \Red61\Via\Exception\ViaException;

/**
 * Exception is used to indicate that a call has been made using a customer that is no longer active/usable
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\Exception\BadCustomerException.
 *
 * @package    Red61\Via\RawGenerated\Exception
 * @see        \Red61\Via\Exception\BadCustomerException.
 */
abstract class RawBadCustomerException extends \SoapFault implements ViaException {

  /**
   * 
   *
   * @var mixed
   */
  protected $reason;


  public static function fromSoapFault(\SoapFault $fault)
  {
    $e = new static(
        $fault->faultcode,
        $fault->faultstring,
        $fault->faultactor,
        $fault->detail
    );
    if (isset($fault->detail->BadCustomerException->reason)) {
      $e->reason = $fault->detail->BadCustomerException->reason;
    }

    return $e;
  }

  /**
   * 
   *
   * @return mixed
   */
  public function getReason()
  {
    return $this->reason;
  }


}
