<?php
/**
 * Defines Red61\Via\Plugin\ViaCorePluginManager
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace Red61\Via\Plugin;

/**
 * This is the default ViaPluginManager implementation. End-users who wish to integrate with their own
 * application's event dispatcher may wish to either replace this, or register a plugin that transfers
 * events between the two.
 *
 * @package Red61\Via\Plugin
 * @see     spec\Red61\Via\Plugin\ViaCorePluginManagerSpec
 */
class ViaCorePluginManager implements ViaPluginManager {

	/**
	 * @var array
	 */
	protected $plugin_defs = array();

	/**
	 * {@inheritdoc}
	 */
	public function notify(ViaPluginNotification $notification)
	{
		$notification_name = $notification->getNotificationName();

		foreach ($this->plugin_defs as $plugin_def)
		{
			$wants_this = (
				($plugin_def['only_notifications'] === NULL)
				OR (in_array($notification_name, $plugin_def['only_notifications']))
			);
			if ($wants_this) {
				/** @var ViaPluginInterface $plugin */
				$plugin = $plugin_def['plugin'];
				$plugin->onViaPluginNotification($notification);
			}
		}
	}

	/**
	 * {@inheritdoc}
	 */
	public function registerPlugin(ViaPluginInterface $plugin, $only_notifications = NULL)
	{
		$this->plugin_defs[] = array(
			'plugin'             => $plugin,
			'only_notifications' => $only_notifications
		);
		return $this;

	}

	/**
	 * Remove a plugin from the list of registered plugins
	 *
	 * @param ViaPluginInterface $plugin
	 *
	 * @return $this
	 * @throws \InvalidArgumentException
	 */
	public function removePlugin(ViaPluginInterface $plugin)
	{
		foreach ($this->plugin_defs as $index => $plugin_definition) {
			if ($plugin_definition['plugin'] === $plugin) {
				unset($this->plugin_defs[$index]);
				return $this;
			}
		}

		throw new \InvalidArgumentException("Could not remove unregistered plugin ".get_class($plugin));
	}

	/**
	 * Get the list of registered plugins
	 *
	 * This is an array of arrays ('plugin' => $plugin, 'only_notifications' => array()|null)
	 *
	 * @return array
	 */
	public function getPluginDefinitions()
	{
		return $this->plugin_defs;
	}

}
