<?php
/**
 * Defines AutoloaderSpec - specifications for \Red61\Via\Autoloader
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via;

use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @var \Red61\Via\Autoloader
 */
class AutoloaderSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\Autoloader
     */
	  protected $subject;

    protected $tmp_dirs = array();

    function let()
    {
        $this->subject->beAnInstanceOf('Red61\Via\Autoloader');
    }

    function letgo()
    {
        foreach ($this->tmp_dirs as $dir)
        {
          `rm -rf $dir`;
        }
    }

    function it_is_initializable()
    {
        $this->subject->shouldHaveType('Red61\Via\Autoloader');
    }

    function it_loads_existing_class_file()
    {
        $basedir = $this->given_temp_directory();
        $this->subject->beConstructedWith($basedir);
        $this->subject->register_autoloader();

        $path    = $basedir.'/Red61/Via';
        mkdir($path, 0700, TRUE);
        file_put_contents($path.'/Dummy.php', '<?php class Red61_Via_Dummy {}');
        expect(class_exists('Red61_Via_Dummy', TRUE))->toBe(TRUE);
    }

    function it_does_not_try_to_load_nonexisting_class()
    {
        $this->subject->beConstructedWith(__DIR__);
        $this->subject->register_autoloader();
        expect(class_exists('Red61_Via_Made_Up_Class', TRUE))->toBe(FALSE);
    }

    function it_finds_red61_via_with_legacy_case()
    {
        $this->subject->beConstructedWith('/foo');
        $this->subject->_find_classpath('red61_via')->shouldBe('/foo/Red61/Via.php');
    }

   function it_finds_red61_cache_with_legacy_case()
    {
        $this->subject->beConstructedWith('/foo');
        $this->subject->_find_classpath('red61_cache')->shouldBe('/foo/Red61/Cache.php');
    }

    function it_finds_psr0_underscored_red61_class()
    {
        $this->subject->beConstructedWith('/foo');
        $this->subject->_find_classpath('Red61_Via_ApiObject_doSomethingToBasket')->shouldBe('/foo/Red61/Via/ApiObject/doSomethingToBasket.php');
    }

  /**
   * @return string
   */
  protected function given_temp_directory()
  {
    $basedir = sys_get_temp_dir().'/'.uniqid('via-autoload-test');
    mkdir($basedir, 0700, TRUE);
    $this->tmp_dirs[] = $basedir;

    return $basedir;
  }

}

