<?php
/**
 * Defines the RawViaApiEventPerformance data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Represents a performance and contains added event information.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiEventPerformance.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiEventPerformance.
 */
abstract class RawViaApiEventPerformance {

  /**
   * The reference of this performance in the form "serverId:performanceId".
   *
   * @var string
   */
  protected $id;

  /**
   * The title of this performance.
   *
   * @var string
   */
  protected $title;

  /**
   * The description of this performance.
   *
   * @var string
   */
  protected $description;

  /**
   * The date this performance takes place in the form "yyyy-MM-dd HH:mm:ss". See the `java.text.SimpleDateFormat`
   * documentation for information on this format.
   *
   * @var string
   */
  protected $datetime;

  /**
   * The current performance status. One of "On Sale", "Cancelled" or "Stopped".
   *
   * @var string
   */
  protected $status;

  /**
   * A string representation of the duration of the performance in minutes (i.e. "60", "120" e.t.c.).
   *
   * @var string
   */
  protected $duration;

  /**
   * The reference of the event this performance is a part of in the form "serverId:eventId".
   *
   * @var string
   */
  protected $eventid;

  /**
   * The full price of the cheapest price band.
   *
   * @var string
   */
  protected $minfullprice;

  /**
   * The full price of the most expensive price band.
   *
   * @var string
   */
  protected $maxfullprice;

  /**
   * The reference of the scheme this performance is a member of if any in the form "serverId:schemeId"
   *
   * @var string
   */
  protected $schemereference;

  /**
   * Whether or not this performance is in a priority booking period.
   *
   * @var bool
   */
  protected $inpriority;

  /**
   * Whether this performance has reserved seating or not.
   *
   * @var bool
   */
  protected $reserved;

  /**
   * Has the performance been cancelled
   *
   * @var bool
   */
  protected $isCancelled;

  /**
   * The performance concessions associated with this performance.
   *
   * @var \Red61\Via\DataObject\ViaApiPerformanceConcession[]
   */
  protected $concessions;

  /**
   * Whether or not this performance is set to sell tickets for the entirety of its duration.
   *
   * @var bool
   */
  protected $listForDuration;

  /**
   * The time at which attendees will be allowed into the venue.
   *
   * @var string
   */
  protected $admissionTime;

  /**
   * URL where content for performance can be accessed.
   *
   * @var string
   */
  protected $contentUrl;

  /**
   * The title of the event this performance belongs to.
   *
   * @var string
   */
  protected $eventTitle;

  /**
   * The distance from the supplied latlong in meters
   *
   * @var double
   */
  protected $distance;

  /**
   * The venue of the event this performance belongs to.
   *
   * @var string
   */
  protected $venue;

  /**
   * The sub venue of the event this performance belongs to.
   *
   * @var string
   */
  protected $subVenue;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'id':
        return $this->getId();
      case 'title':
        return $this->getTitle();
      case 'description':
        return $this->getDescription();
      case 'datetime':
        return $this->getDatetime();
      case 'status':
        return $this->getStatus();
      case 'duration':
        return $this->getDuration();
      case 'eventid':
        return $this->getEventid();
      case 'minfullprice':
        return $this->getMinfullprice();
      case 'maxfullprice':
        return $this->getMaxfullprice();
      case 'schemereference':
        return $this->getSchemereference();
      case 'inpriority':
        return $this->getInpriority();
      case 'reserved':
        return $this->getReserved();
      case 'isCancelled':
        return $this->getIsCancelled();
      case 'concessions':
        return $this->getConcessions();
      case 'listForDuration':
        return $this->getListForDuration();
      case 'admissionTime':
        return $this->getAdmissionTime();
      case 'contentUrl':
        return $this->getContentUrl();
      case 'eventTitle':
        return $this->getEventTitle();
      case 'distance':
        return $this->getDistance();
      case 'venue':
        return $this->getVenue();
      case 'subVenue':
        return $this->getSubVenue();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of this performance in the form "serverId:performanceId".
   *
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }


  /**
   * The title of this performance.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The description of this performance.
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


  /**
   * The date this performance takes place in the form "yyyy-MM-dd HH:mm:ss". See the `java.text.SimpleDateFormat`
   * documentation for information on this format.
   *
   * @return string
   */
  public function getDatetime()
  {
    return $this->datetime;
  }


  /**
   * The current performance status. One of "On Sale", "Cancelled" or "Stopped".
   *
   * @return string
   */
  public function getStatus()
  {
    return $this->status;
  }


  /**
   * A string representation of the duration of the performance in minutes (i.e. "60", "120" e.t.c.).
   *
   * @return string
   */
  public function getDuration()
  {
    return $this->duration;
  }


  /**
   * The reference of the event this performance is a part of in the form "serverId:eventId".
   *
   * @return string
   */
  public function getEventid()
  {
    return $this->eventid;
  }


  /**
   * The full price of the cheapest price band.
   *
   * @return string
   */
  public function getMinfullprice()
  {
    return $this->minfullprice;
  }


  /**
   * The full price of the most expensive price band.
   *
   * @return string
   */
  public function getMaxfullprice()
  {
    return $this->maxfullprice;
  }


  /**
   * The reference of the scheme this performance is a member of if any in the form "serverId:schemeId"
   *
   * @return string
   */
  public function getSchemereference()
  {
    return $this->schemereference;
  }


  /**
   * Whether or not this performance is in a priority booking period.
   *
   * @return bool
   */
  public function getInpriority()
  {
    return $this->inpriority;
  }


  /**
   * Whether this performance has reserved seating or not.
   *
   * @return bool
   */
  public function getReserved()
  {
    return $this->reserved;
  }


  /**
   * Has the performance been cancelled
   *
   * @return bool
   */
  public function getIsCancelled()
  {
    return $this->isCancelled;
  }


  /**
   * The performance concessions associated with this performance.
   *
   * @return \Red61\Via\DataObject\ViaApiPerformanceConcession[]
   */
  public function getConcessions()
  {
	return $this->concessions ? : array();
  }


  /**
   * Whether or not this performance is set to sell tickets for the entirety of its duration.
   *
   * @return bool
   */
  public function getListForDuration()
  {
    return $this->listForDuration;
  }


  /**
   * The time at which attendees will be allowed into the venue.
   *
   * @return string
   */
  public function getAdmissionTime()
  {
    return $this->admissionTime;
  }


  /**
   * URL where content for performance can be accessed.
   *
   * @return string
   */
  public function getContentUrl()
  {
    return $this->contentUrl;
  }


  /**
   * The title of the event this performance belongs to.
   *
   * @return string
   */
  public function getEventTitle()
  {
    return $this->eventTitle;
  }


  /**
   * The distance from the supplied latlong in meters
   *
   * @return double
   */
  public function getDistance()
  {
    return $this->distance;
  }


  /**
   * The venue of the event this performance belongs to.
   *
   * @return string
   */
  public function getVenue()
  {
    return $this->venue;
  }


  /**
   * The sub venue of the event this performance belongs to.
   *
   * @return string
   */
  public function getSubVenue()
  {
    return $this->subVenue;
  }


}
