<?php
/**
 * Defines the RawapiLoginRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Gets the customer id associated with the supplied e-mail address and password.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiLoginRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiLoginRequest.
 */
abstract class RawapiLoginRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiLogin';

  /**
   * email address of the customer, which must not be `null` or the empty string
   *
   * @var string
   */
  protected $email;

  /**
   * password of the customer, which must not be `null` or the empty string
   *
   * @var string
   */
  protected $password;

  /**
   * authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * email address of the customer, which must not be `null` or the empty string
   *
   * @return string
   */
  public function getEmail()
  {
    return $this->email;
  }


  /**
   * email address of the customer, which must not be `null` or the empty string
   *
   * @param string $email
   *
   * @return $this
   */
  public function setEmail($email)
  {
    $this->email = $email;
    return $this;
  }

  /**
   * password of the customer, which must not be `null` or the empty string
   *
   * @return string
   */
  public function getPassword()
  {
    return $this->password;
  }


  /**
   * password of the customer, which must not be `null` or the empty string
   *
   * @param string $password
   *
   * @return $this
   */
  public function setPassword($password)
  {
    $this->password = $password;
    return $this;
  }

  /**
   * authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
