<?php
/**
 * Defines the RawapiAddOrderNoteRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Adds a transaction note of the specified type to the transaction for the given Id.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiAddOrderNoteRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiAddOrderNoteRequest.
 */
abstract class RawapiAddOrderNoteRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiAddOrderNote';

  /**
   * Order to which you wish to add transaction notes, in format 'serverId:orderId'
   *
   * @var string
   */
  protected $orderId;

  /**
   * The type of the transaction note. (Max 50 characters)
   *
   * @var string
   */
  protected $type;

  /**
   * The value of the note desired on the transaction
   *
   * @var string
   */
  protected $note;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * Order to which you wish to add transaction notes, in format 'serverId:orderId'
   *
   * @return string
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * Order to which you wish to add transaction notes, in format 'serverId:orderId'
   *
   * @param string $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * The type of the transaction note. (Max 50 characters)
   *
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }


  /**
   * The type of the transaction note. (Max 50 characters)
   *
   * @param string $type
   *
   * @return $this
   */
  public function setType($type)
  {
    $this->type = $type;
    return $this;
  }

  /**
   * The value of the note desired on the transaction
   *
   * @return string
   */
  public function getNote()
  {
    return $this->note;
  }


  /**
   * The value of the note desired on the transaction
   *
   * @param string $note
   *
   * @return $this
   */
  public function setNote($note)
  {
    $this->note = $note;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
