<?php
/**
 * Defines PhpNativeSessionStorageSpec - specifications for Red61\Via\Session\PhpNativeSessionStorage
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\SessionStorage;

use PhpSpec\Exception\Example\FailureException;
use Prophecy\Argument;
use spec\ObjectBehavior;

/**
 *
 * @see Red61\Via\Session\PhpNativeSessionStorage
 */
class PhpNativeSessionStorageSpec extends ObjectBehavior
{
	const BASKET_ID = '5123:23233:33323';
	/**
	 * Use $this->subject to get proper type hinting for the subject class
	 * @var \Red61\Via\SessionStorage\PhpNativeSessionStorage
	 */
	protected $subject;

	function let()
	{
		if (session_id()) {
			session_destroy();
		}
	}

	function it_is_initializable()
	{
		$this->subject->shouldHaveType('Red61\Via\SessionStorage\PhpNativeSessionStorage');
		$this->subject->shouldHaveType('Red61\Via\SessionStorage\ViaSessionStorage');
	}

	function its_load_basket_id_throws_if_session_not_started()
	{
		try {
			$this->subject->loadBasketId();
			throw new FailureException("Should throw an exception if session is not started");
		} catch (\BadMethodCallException $e) {
			// OK
		}
	}

	function it_loads_basket_id_from_session_superglobal()
	{
		session_start();
		$_SESSION['via_basket_id'] = self::BASKET_ID;
		$this->subject->loadBasketId()->shouldBe(self::BASKET_ID);
	}

	function it_loads_null_basket_id_if_session_var_not_set()
	{
		session_start();
		if (isset($_SESSION['via_basket_id'])) {
			unset($_SESSION['via_basket_id']);
		}
		$this->subject->loadBasketId()->shouldBe(NULL);
	}

	function its_store_basket_id_throws_if_session_not_started()
	{
		try {
			$this->subject->saveBasketId('foobar');
			throw new FailureException("Should throw an exception if session is not started");
		} catch (\BadMethodCallException $e) {
			// OK
		}
	}

	function it_stores_basket_id_in_session_superglobal()
	{
		session_start();
		$this->subject->saveBasketId(self::BASKET_ID);
		expect($_SESSION['via_basket_id'])->toBe(self::BASKET_ID);
	}

	function its_session_key_can_be_configured()
	{
		session_start();
		$this->beConstructedWith('RANDOM');
		$this->subject->saveBasketId(self::BASKET_ID);
		$this->subject->loadBasketId()->shouldBe(self::BASKET_ID);
		expect($_SESSION['RANDOM'])->toBe(self::BASKET_ID);
	}

}
