<?php
/**
 * Defines ViaCacheKeyGeneratorSpec - specifications for Red61\Via\Cache\ViaCacheKeyGenerator
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\Cache;

use Red61\Via\ApiRequest\apiCreateAccountRequest;
use Red61\Via\ApiRequest\apiGetCustomerDetailsRequest;
use Red61\Via\ApiRequest\apiGetCustomerNameRequest;
use Red61\Via\ApiRequest\apiGetEventsRequest;
use Red61\Via\ApiRequest\apiGetEventDetailsRequest;
use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\Cache\ViaCacheKeyGenerator
 */
class ViaCacheKeyGeneratorSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\Cache\ViaCacheKeyGenerator
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\Cache\ViaCacheKeyGenerator');
	}

	function it_returns_string_key_for_api_request()
	{
		$this->subject->get_key(new apiGetEventsRequest)->shouldBeString();
	}

	function it_returns_same_key_for_same_object()
	{
		$obj = new apiGetEventsRequest;
		$key1 = $this->subject->get_key($obj);
		$this->subject->get_key($obj)->shouldBe($key1);
	}

	function it_returns_same_key_for_objects_with_same_params()
	{
		$key1 = $this->subject->get_key(apiGetEventDetailsRequest::create()->setEventRef('5926:1:2'));
		$key2 = $this->subject->get_key(apiGetEventDetailsRequest::create()->setEventRef('5926:1:2'));

		$key2->shouldBe($key1);
	}

	function it_returns_different_key_for_objects_with_different_params()
	{
		$key1 = $this->subject->get_key(apiGetEventDetailsRequest::create()->setEventRef('5926:1:2'));
		$key2 = $this->subject->get_key(apiGetEventDetailsRequest::create()->setEventRef('5926:1:3'));

		$key2->shouldNotBe($key1);
	}

	function it_returns_different_key_for_objects_with_same_params_and_different_type()
	{
		$key1 = $this->subject->get_key(apiGetCustomerDetailsRequest::create()->setCustomerId(12));
		$key2 = $this->subject->get_key(apiGetCustomerNameRequest::create()->setCustomerId(12));

		$key1->shouldNotBe($key2);
	}

	function its_key_matches_expected_character_set()
	{
		$key = $this->subject->get_key(apiCreateAccountRequest::create()->setForename(' '));
		$key->shouldMatch('/^[a-zA-Z0-9\-_]+$/');
	}

	function its_key_should_be_shorter_than_250_chars()
	{
		$key = $this->subject->get_key(apiCreateAccountRequest::create()->setForename(' '));
		$key->shouldMatch('/^.{1,250}$/');
	}

	function it_includes_method_name_in_key_for_debugging_and_inspection()
	{
		$key1 = $this->subject->get_key(apiGetEventDetailsRequest::create()->setEventRef('5926:1:2'));

		$key1->shouldMatch('/'.apiGetEventDetailsRequest::SOAP_METHOD_NAME.'/');
	}

}
