<?php
/**
 * Defines the RawapiAddTicketsWithAttributesToBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Adds the supplied tickets with the attributes to the basket identified by `sessionId`.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiAddTicketsWithAttributesToBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiAddTicketsWithAttributesToBasketRequest.
 */
abstract class RawapiAddTicketsWithAttributesToBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiAddTicketsWithAttributesToBasket';

  /**
   * ID of the server/performance to add tickets from.
   *
   * @var string
   */
  protected $performanceRef;

  /**
   * An array of `ViaApiTicketAttributeRequest` objects containing details about the requested tickets and the requested
   * attributes
   *
   * @var \Red61\Via\DataObject\ViaApiTicketAttributeRequest[]
   */
  protected $ticketAttributes;

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * ID of the server/performance to add tickets from.
   *
   * @return string
   */
  public function getPerformanceRef()
  {
    return $this->performanceRef;
  }


  /**
   * ID of the server/performance to add tickets from.
   *
   * @param string $performanceRef
   *
   * @return $this
   */
  public function setPerformanceRef($performanceRef)
  {
    $this->performanceRef = $performanceRef;
    return $this;
  }

  /**
   * An array of `ViaApiTicketAttributeRequest` objects containing details about the requested tickets and the requested
   * attributes
   *
   * @return \Red61\Via\DataObject\ViaApiTicketAttributeRequest[]
   */
  public function getTicketAttributes()
  {
    return $this->ticketAttributes;
  }


  /**
   * An array of `ViaApiTicketAttributeRequest` objects containing details about the requested tickets and the requested
   * attributes
   *
   * @param \Red61\Via\DataObject\ViaApiTicketAttributeRequest[] $ticketAttributes
   *
   * @return $this
   */
  public function setTicketAttributes($ticketAttributes)
  {
    $this->ticketAttributes = $ticketAttributes;
    return $this;
  }

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
