<?php
/**
 * Defines apiSetAffiliateRequestSpec - specifications for Red61\Via\ApiRequest\apiSetAffiliateRequest
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\ApiRequest;

use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\ApiRequest\apiSetAffiliateRequest
 */
class apiSetAffiliateRequestSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\ApiRequest\apiSetAffiliateRequest
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\apiSetAffiliateRequest');
	}

	function it_is_a_lazy_basket_metadata_setting_request()
	{
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\LazyBasketMetadataSettingRequest');
	}

	function it_truncates_code_to_50_chars()
	{
		$fifty     = str_repeat('1234567890', 5);
		$fifty_one = $fifty.'1';
		$this->subject
			->setAffiliateCode($fifty_one)
			->getAffiliateCode()->shouldBe($fifty);
	}

	function it_truncates_token_to_125_chars()
	{
		$hundred_twenty_five = str_repeat('1234567890', 12).'12345';
		$hundred_twenty_six  = $hundred_twenty_five.'6';
		$this->subject
			->setAffiliateToken($hundred_twenty_six)
			->getAffiliateToken()->shouldBe($hundred_twenty_five);
	}


}
