<?php
/**
 * Defines the RawapiGetPerformancesByTimeRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Lists performances based on the supplied parameters.Returned list is ordered by ascending performance date.`typeid`
 * and `subtypeid` must be used in conjunction with other parameters (otherwise no results are returned). This method
 * will attempt translation of it's returned objects, where available.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetPerformancesByTimeRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetPerformancesByTimeRequest.
 */
abstract class RawapiGetPerformancesByTimeRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetPerformancesByTime';

  /**
   * The event name.
   *
   * @var string
   */
  protected $eventName;

  /**
   * The venue name.
   *
   * @var string
   */
  protected $venueName;

  /**
   * The subvenue name.
   *
   * @var string
   */
  protected $subvenueName;

  /**
   * The artist name.
   *
   * @var string
   */
  protected $company;

  /**
   * The promoter name.
   *
   * @var string
   */
  protected $promoter;

  /**
   * The start of an events performances. e.g. "2013-12-01 12:00"
   *
   * @var string
   */
  protected $startDate;

  /**
   * The enddate of an events performances (not inclusive). e.g. "2013-12-02 14:00"
   *
   * @var string
   */
  protected $endingDate;

  /**
   * The type ID. Must be used in conjunction with another parameter.
   *
   * @var int
   */
  protected $typeId;

  /**
   * The sub-type ID. Must be used in conjunction with another parameter.
   *
   * @var int
   */
  protected $subTypeId;

  /**
   * The season code.
   *
   * @var string
   */
  protected $seasonCode;

  /**
   * The latitude and longitude in the form latitude,longitude you wish to search relative to.
   *
   * @var string
   */
  protected $latLong;

  /**
   * The radius in metres from the latLong you wish to search within.
   *
   * @var int
   */
  protected $radius;

  /**
   * The format code to filter by.
   *
   * @var string
   */
  protected $presentationFormat;

  /**
   * the authentication code to use
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The event name.
   *
   * @return string
   */
  public function getEventName()
  {
    return $this->eventName;
  }


  /**
   * The event name.
   *
   * @param string $eventName
   *
   * @return $this
   */
  public function setEventName($eventName)
  {
    $this->eventName = $eventName;
    return $this;
  }

  /**
   * The venue name.
   *
   * @return string
   */
  public function getVenueName()
  {
    return $this->venueName;
  }


  /**
   * The venue name.
   *
   * @param string $venueName
   *
   * @return $this
   */
  public function setVenueName($venueName)
  {
    $this->venueName = $venueName;
    return $this;
  }

  /**
   * The subvenue name.
   *
   * @return string
   */
  public function getSubvenueName()
  {
    return $this->subvenueName;
  }


  /**
   * The subvenue name.
   *
   * @param string $subvenueName
   *
   * @return $this
   */
  public function setSubvenueName($subvenueName)
  {
    $this->subvenueName = $subvenueName;
    return $this;
  }

  /**
   * The artist name.
   *
   * @return string
   */
  public function getCompany()
  {
    return $this->company;
  }


  /**
   * The artist name.
   *
   * @param string $company
   *
   * @return $this
   */
  public function setCompany($company)
  {
    $this->company = $company;
    return $this;
  }

  /**
   * The promoter name.
   *
   * @return string
   */
  public function getPromoter()
  {
    return $this->promoter;
  }


  /**
   * The promoter name.
   *
   * @param string $promoter
   *
   * @return $this
   */
  public function setPromoter($promoter)
  {
    $this->promoter = $promoter;
    return $this;
  }

  /**
   * The start of an events performances. e.g. "2013-12-01 12:00"
   *
   * @return string
   */
  public function getStartDate()
  {
    return $this->startDate;
  }


  /**
   * The start of an events performances. e.g. "2013-12-01 12:00"
   *
   * @param string $startDate
   *
   * @return $this
   */
  public function setStartDate($startDate)
  {
    $this->startDate = $startDate;
    return $this;
  }

  /**
   * The enddate of an events performances (not inclusive). e.g. "2013-12-02 14:00"
   *
   * @return string
   */
  public function getEndingDate()
  {
    return $this->endingDate;
  }


  /**
   * The enddate of an events performances (not inclusive). e.g. "2013-12-02 14:00"
   *
   * @param string $endingDate
   *
   * @return $this
   */
  public function setEndingDate($endingDate)
  {
    $this->endingDate = $endingDate;
    return $this;
  }

  /**
   * The type ID. Must be used in conjunction with another parameter.
   *
   * @return int
   */
  public function getTypeId()
  {
    return $this->typeId;
  }


  /**
   * The type ID. Must be used in conjunction with another parameter.
   *
   * @param int $typeId
   *
   * @return $this
   */
  public function setTypeId($typeId)
  {
    $this->typeId = $typeId;
    return $this;
  }

  /**
   * The sub-type ID. Must be used in conjunction with another parameter.
   *
   * @return int
   */
  public function getSubTypeId()
  {
    return $this->subTypeId;
  }


  /**
   * The sub-type ID. Must be used in conjunction with another parameter.
   *
   * @param int $subTypeId
   *
   * @return $this
   */
  public function setSubTypeId($subTypeId)
  {
    $this->subTypeId = $subTypeId;
    return $this;
  }

  /**
   * The season code.
   *
   * @return string
   */
  public function getSeasonCode()
  {
    return $this->seasonCode;
  }


  /**
   * The season code.
   *
   * @param string $seasonCode
   *
   * @return $this
   */
  public function setSeasonCode($seasonCode)
  {
    $this->seasonCode = $seasonCode;
    return $this;
  }

  /**
   * The latitude and longitude in the form latitude,longitude you wish to search relative to.
   *
   * @return string
   */
  public function getLatLong()
  {
    return $this->latLong;
  }


  /**
   * The latitude and longitude in the form latitude,longitude you wish to search relative to.
   *
   * @param string $latLong
   *
   * @return $this
   */
  public function setLatLong($latLong)
  {
    $this->latLong = $latLong;
    return $this;
  }

  /**
   * The radius in metres from the latLong you wish to search within.
   *
   * @return int
   */
  public function getRadius()
  {
    return $this->radius;
  }


  /**
   * The radius in metres from the latLong you wish to search within.
   *
   * @param int $radius
   *
   * @return $this
   */
  public function setRadius($radius)
  {
    $this->radius = $radius;
    return $this;
  }

  /**
   * The format code to filter by.
   *
   * @return string
   */
  public function getPresentationFormat()
  {
    return $this->presentationFormat;
  }


  /**
   * The format code to filter by.
   *
   * @param string $presentationFormat
   *
   * @return $this
   */
  public function setPresentationFormat($presentationFormat)
  {
    $this->presentationFormat = $presentationFormat;
    return $this;
  }

  /**
   * the authentication code to use
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * the authentication code to use
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
