<?php
/**
 * Defines the RawapiAddPerformanceAccessNotesToBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Adds and updates the specified access note for performance(s) already in the basket identified by `sessionId`. For
 * the note to be added to a performance: 1. A customer should already be attached to the basket. 2. A ticket for the
 * target performance should already be in the basket. 3. At least one `accessNoteCategoryId` should be specified.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiAddPerformanceAccessNotesToBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiAddPerformanceAccessNotesToBasketRequest.
 */
abstract class RawapiAddPerformanceAccessNotesToBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiAddPerformanceAccessNotesToBasket';

  /**
   * An array of access note category ID's associated with the access note to be updated.
   *
   * @var int[]
   */
  protected $accessNoteCategoryIds;

  /**
   * The message content of the access note (optional).
   *
   * @var string
   */
  protected $accessNoteContent;

  /**
   * An array of perfKeys of the form "serverId:performanceId".
   *
   * @var string[]
   */
  protected $performanceRefs;

  /**
   * The ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * An array of access note category ID's associated with the access note to be updated.
   *
   * @return int[]
   */
  public function getAccessNoteCategoryIds()
  {
    return $this->accessNoteCategoryIds;
  }


  /**
   * An array of access note category ID's associated with the access note to be updated.
   *
   * @param int[] $accessNoteCategoryIds
   *
   * @return $this
   */
  public function setAccessNoteCategoryIds($accessNoteCategoryIds)
  {
    $this->accessNoteCategoryIds = $accessNoteCategoryIds;
    return $this;
  }

  /**
   * The message content of the access note (optional).
   *
   * @return string
   */
  public function getAccessNoteContent()
  {
    return $this->accessNoteContent;
  }


  /**
   * The message content of the access note (optional).
   *
   * @param string $accessNoteContent
   *
   * @return $this
   */
  public function setAccessNoteContent($accessNoteContent)
  {
    $this->accessNoteContent = $accessNoteContent;
    return $this;
  }

  /**
   * An array of perfKeys of the form "serverId:performanceId".
   *
   * @return string[]
   */
  public function getPerformanceRefs()
  {
    return $this->performanceRefs;
  }


  /**
   * An array of perfKeys of the form "serverId:performanceId".
   *
   * @param string[] $performanceRefs
   *
   * @return $this
   */
  public function setPerformanceRefs($performanceRefs)
  {
    $this->performanceRefs = $performanceRefs;
    return $this;
  }

  /**
   * The ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
