<?php
/**
 * Defines the apiCreateRepeatPaymentOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;

/**
 * @package    Red61\Via\ApiRequest
 * {@inheritdoc}
 */
class apiCreateRepeatPaymentOrderRequest
	extends \Red61\Via\RawGenerated\ApiRequest\RawapiCreateRepeatPaymentOrderRequest
	implements OrderCompletingRequest {

	/**
	 * Sets the value, truncating to 20 characters
	 * {@inheritdoc}
	 */
	public function setWorkstationId($workstationId)
	{
		return parent::setWorkstationId(substr($workstationId, 0, 20));
	}

}
