<?php
/**
 * Defines the RawViaApiSubVenueDetails data object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the information for a particular sub venue.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiSubVenueDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiSubVenueDetails.
 */
abstract class RawViaApiSubVenueDetails {

  /**
   * The reference of this venue in the form "serverId:subvenueId".
   *
   * @var string
   */
  protected $subVenueRef;

  /**
   * The title of this sub venue
   *
   * @var string
   */
  protected $title;

  /**
   * The description of this sub venue
   *
   * @var string
   */
  protected $description;

  /**
   * The first address line of this sub venue
   *
   * @var string
   */
  protected $address1;

  /**
   * The second address line of this sub venue
   *
   * @var string
   */
  protected $address2;

  /**
   * The town this sub venue is situated
   *
   * @var string
   */
  protected $town;

  /**
   * The county this sub venue is situated
   *
   * @var string
   */
  protected $county;

  /**
   * The country this sub venue is situated.
   *
   * @var string
   */
  protected $country;

  /**
   * The postcode for this sub venue
   *
   * @var string
   */
  protected $post_code;

  /**
   * The contact name for this sub venue
   *
   * @var string
   */
  protected $contact_name;

  /**
   * The telephone number for this sub venue
   *
   * @var string
   */
  protected $telephone;

  /**
   * The box office number for this sub venue
   *
   * @var string
   */
  protected $boxoffice;

  /**
   * The fax number for this sub venue
   *
   * @var string
   */
  protected $fax;

  /**
   * The email for this sub venue
   *
   * @var string
   */
  protected $email;

  /**
   * The code for this sub venue
   *
   * @var string
   */
  protected $venue_code;

  /**
   * The notes on this sub venue
   *
   * @var string
   */
  protected $notes;

  /**
   * The sort order of this sub venue
   *
   * @var int
   */
  protected $sortOrder;

  /**
   * The string representation of the latitude of this venue. Displayed
   * as a number from -90 to 90.
   *
   * @var string
   */
  protected $latitude;

  /**
   * The string representation of the longitude of this venue. Displayed
   * as a number from -90 to 90.
   *
   * @var string
   */
  protected $longitude;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'subVenueRef':
        return $this->getSubVenueRef();
      case 'title':
        return $this->getTitle();
      case 'description':
        return $this->getDescription();
      case 'address1':
        return $this->getAddress1();
      case 'address2':
        return $this->getAddress2();
      case 'town':
        return $this->getTown();
      case 'county':
        return $this->getCounty();
      case 'country':
        return $this->getCountry();
      case 'post_code':
        return $this->getPost_code();
      case 'contact_name':
        return $this->getContact_name();
      case 'telephone':
        return $this->getTelephone();
      case 'boxoffice':
        return $this->getBoxoffice();
      case 'fax':
        return $this->getFax();
      case 'email':
        return $this->getEmail();
      case 'venue_code':
        return $this->getVenue_code();
      case 'notes':
        return $this->getNotes();
      case 'sortOrder':
        return $this->getSortOrder();
      case 'latitude':
        return $this->getLatitude();
      case 'longitude':
        return $this->getLongitude();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of this venue in the form "serverId:subvenueId".
   *
   * @return string
   */
  public function getSubVenueRef()
  {
    return $this->subVenueRef;
  }


  /**
   * The title of this sub venue
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The description of this sub venue
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


  /**
   * The first address line of this sub venue
   *
   * @return string
   */
  public function getAddress1()
  {
    return $this->address1;
  }


  /**
   * The second address line of this sub venue
   *
   * @return string
   */
  public function getAddress2()
  {
    return $this->address2;
  }


  /**
   * The town this sub venue is situated
   *
   * @return string
   */
  public function getTown()
  {
    return $this->town;
  }


  /**
   * The county this sub venue is situated
   *
   * @return string
   */
  public function getCounty()
  {
    return $this->county;
  }


  /**
   * The country this sub venue is situated.
   *
   * @return string
   */
  public function getCountry()
  {
    return $this->country;
  }


  /**
   * The postcode for this sub venue
   *
   * @return string
   */
  public function getPost_code()
  {
    return $this->post_code;
  }


  /**
   * The contact name for this sub venue
   *
   * @return string
   */
  public function getContact_name()
  {
    return $this->contact_name;
  }


  /**
   * The telephone number for this sub venue
   *
   * @return string
   */
  public function getTelephone()
  {
    return $this->telephone;
  }


  /**
   * The box office number for this sub venue
   *
   * @return string
   */
  public function getBoxoffice()
  {
    return $this->boxoffice;
  }


  /**
   * The fax number for this sub venue
   *
   * @return string
   */
  public function getFax()
  {
    return $this->fax;
  }


  /**
   * The email for this sub venue
   *
   * @return string
   */
  public function getEmail()
  {
    return $this->email;
  }


  /**
   * The code for this sub venue
   *
   * @return string
   */
  public function getVenue_code()
  {
    return $this->venue_code;
  }


  /**
   * The notes on this sub venue
   *
   * @return string
   */
  public function getNotes()
  {
    return $this->notes;
  }


  /**
   * The sort order of this sub venue
   *
   * @return int
   */
  public function getSortOrder()
  {
    return $this->sortOrder;
  }


  /**
   * The string representation of the latitude of this venue. Displayed
   * as a number from -90 to 90.
   *
   * @return string
   */
  public function getLatitude()
  {
    return $this->latitude;
  }


  /**
   * The string representation of the longitude of this venue. Displayed
   * as a number from -90 to 90.
   *
   * @return string
   */
  public function getLongitude()
  {
    return $this->longitude;
  }


}
