<?php
/**
 * Defines the RawViaApiSchemeDetails data object
 *
 * @author    Red61 Ltd
 * @copyright 2016 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the details of a particular scheme.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiSchemeDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiSchemeDetails.
 */
abstract class RawViaApiSchemeDetails {

  /**
   * The reference of the scheme this tier is a member of in the form "serverId:schemeId"
   *
   * @var string
   */
  protected $schemeRef;

  /**
   * The title of the scheme this tier is a member of.
   *
   * @var string
   */
  protected $title;

  /**
   * The code of the scheme this tier is a member of.
   *
   * @var string
   */
  protected $code;

  /**
   * The notes on the scheme this tier is a member of.
   *
   * @var string
   */
  protected $notes;

  /**
   * The start date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @var string
   */
  protected $startDate;

  /**
   * The end date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @var string
   */
  protected $endDate;

  /**
   * The priority start date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @var string
   */
  protected $priorityStartDate;

  /**
   * The priority end date of the scheme this tier is a member ofin the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @var string
   */
  protected $priorityEndDate;

  /**
   * The gift aid declaration text.
   *
   * @var string
   */
  protected $giftAidText;

  /**
   * The scheme tiers associated with this scheme.
   *
   * @var \Red61\Via\DataObject\ViaApiSchemeTierDetails[]
   */
  protected $schemeTiers;

  /**
   * If true then this flag indicates that on an early renewal any remaining time on the customer's current subscription
   * 
   * will be added to the duration of the new subscription.
   *
   * @var bool
   */
  protected $renewalRollsOverDuration;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'schemeRef':
        return $this->getSchemeRef();
      case 'title':
        return $this->getTitle();
      case 'code':
        return $this->getCode();
      case 'notes':
        return $this->getNotes();
      case 'startDate':
        return $this->getStartDate();
      case 'endDate':
        return $this->getEndDate();
      case 'priorityStartDate':
        return $this->getPriorityStartDate();
      case 'priorityEndDate':
        return $this->getPriorityEndDate();
      case 'giftAidText':
        return $this->getGiftAidText();
      case 'schemeTiers':
        return $this->getSchemeTiers();
      case 'renewalRollsOverDuration':
        return $this->getRenewalRollsOverDuration();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of the scheme this tier is a member of in the form "serverId:schemeId"
   *
   * @return string
   */
  public function getSchemeRef()
  {
    return $this->schemeRef;
  }


  /**
   * The title of the scheme this tier is a member of.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The code of the scheme this tier is a member of.
   *
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }


  /**
   * The notes on the scheme this tier is a member of.
   *
   * @return string
   */
  public function getNotes()
  {
    return $this->notes;
  }


  /**
   * The start date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @return string
   */
  public function getStartDate()
  {
    return $this->startDate;
  }


  /**
   * The end date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @return string
   */
  public function getEndDate()
  {
    return $this->endDate;
  }


  /**
   * The priority start date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @return string
   */
  public function getPriorityStartDate()
  {
    return $this->priorityStartDate;
  }


  /**
   * The priority end date of the scheme this tier is a member ofin the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @return string
   */
  public function getPriorityEndDate()
  {
    return $this->priorityEndDate;
  }


  /**
   * The gift aid declaration text.
   *
   * @return string
   */
  public function getGiftAidText()
  {
    return $this->giftAidText;
  }


  /**
   * The scheme tiers associated with this scheme.
   *
   * @return \Red61\Via\DataObject\ViaApiSchemeTierDetails[]
   */
  public function getSchemeTiers()
  {
	return $this->schemeTiers ? : array();
  }


  /**
   * If true then this flag indicates that on an early renewal any remaining time on the customer's current subscription
   * 
   * will be added to the duration of the new subscription.
   *
   * @return bool
   */
  public function getRenewalRollsOverDuration()
  {
    return $this->renewalRollsOverDuration;
  }


}
