<?php
/**
 * Defines the RawapiRegisterInterestInEventRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is used to register/remove an event interest of a customer if @param interested is true/false
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiRegisterInterestInEventRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiRegisterInterestInEventRequest.
 */
abstract class RawapiRegisterInterestInEventRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiRegisterInterestInEvent';

  /**
   * ID representing the customer adding the event to his wish list.
   *
   * @var int
   */
  protected $customerId;

  /**
   * The serverId and eventId to list events in the form "serverId:eventId"
   *
   * @var string
   */
  protected $eventRef;

  /**
   * boolean indicating whether user wishes to add/remove event from wish list
   *
   * @var bool
   */
  protected $interested;

  /**
   * The type of the customer's interest.
   *
   * @var string
   */
  protected $type;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * ID representing the customer adding the event to his wish list.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * ID representing the customer adding the event to his wish list.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The serverId and eventId to list events in the form "serverId:eventId"
   *
   * @return string
   */
  public function getEventRef()
  {
    return $this->eventRef;
  }


  /**
   * The serverId and eventId to list events in the form "serverId:eventId"
   *
   * @param string $eventRef
   *
   * @return $this
   */
  public function setEventRef($eventRef)
  {
    $this->eventRef = $eventRef;
    return $this;
  }

  /**
   * boolean indicating whether user wishes to add/remove event from wish list
   *
   * @return bool
   */
  public function getInterested()
  {
    return $this->interested;
  }


  /**
   * boolean indicating whether user wishes to add/remove event from wish list
   *
   * @param bool $interested
   *
   * @return $this
   */
  public function setInterested($interested)
  {
    $this->interested = $interested;
    return $this;
  }

  /**
   * The type of the customer's interest.
   *
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }


  /**
   * The type of the customer's interest.
   *
   * @param string $type
   *
   * @return $this
   */
  public function setType($type)
  {
    $this->type = $type;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
