<?php
/**
 * Defines the RawapiGetVenueDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns details on a given venue
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetVenueDetailsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetVenueDetailsRequest.
 */
abstract class RawapiGetVenueDetailsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetVenueDetails';

  /**
   * The serverId and venueId to return information for in the form "serverId:venueId"
   *
   * @var string
   */
  protected $venueRef;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The serverId and venueId to return information for in the form "serverId:venueId"
   *
   * @return string
   */
  public function getVenueRef()
  {
    return $this->venueRef;
  }


  /**
   * The serverId and venueId to return information for in the form "serverId:venueId"
   *
   * @param string $venueRef
   *
   * @return $this
   */
  public function setVenueRef($venueRef)
  {
    $this->venueRef = $venueRef;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
