<?php
/**
 * Defines the RawapiCreateUnpaidAccountOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Creates the entire unpaid  account order => order record, line items and 'unpaid' account payment record.  If this
 * does not return a valid order Id (greater than ZERO) then assume that the unpaid account order has not been created.
 * If this method returns a valid order Id then it is safe to proceed to call   {@link #apiCompleteAccountOrder(String,
 * boolean, String,String)} to complete the order. If the payment fails then this method can be called again  and will
 * persist a new unpaid payment against the original transaction for processing. This will only work however if you
 * first call {@link #apiCompleteAccountOrder(String, boolean, String,String)} to  process the 'failed' payment.
 * Remember to only proceed to take payment if this method returns  a valid orderId (greater than ZERO). The webuser
 * identified by {@code webkey} must have system permission to create transactions with account payments
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCreateUnpaidAccountOrderRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCreateUnpaidAccountOrderRequest.
 */
abstract class RawapiCreateUnpaidAccountOrderRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiCreateUnpaidAccountOrder';

  /**
   * The unique account code identifier
   *
   * @var string
   */
  protected $accountCode;

  /**
   * the webserver hostname making this payment if available. Note: max chars 20, so you may need to truncate
   *
   * @var string
   */
  protected $workstationId;

  /**
   * <code>0</code> to indicate that the order will be collected at the box office, <code>1</code> to indicate that the
   * tickets will be posted out to the customers primary address, <code>2</code> to indicate that the tickets will be
   * posted to the customers alternative address and <code>3</code> to indicate that the tickets have been printed now
   * (outside of VIA)
   *
   * @var int
   */
  protected $deliveryOption;

  /**
   * ID representing the customer making this payment
   *
   * @var int
   */
  protected $customerId;

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The unique account code identifier
   *
   * @return string
   */
  public function getAccountCode()
  {
    return $this->accountCode;
  }


  /**
   * The unique account code identifier
   *
   * @param string $accountCode
   *
   * @return $this
   */
  public function setAccountCode($accountCode)
  {
    $this->accountCode = $accountCode;
    return $this;
  }

  /**
   * the webserver hostname making this payment if available. Note: max chars 20, so you may need to truncate
   *
   * @return string
   */
  public function getWorkstationId()
  {
    return $this->workstationId;
  }


  /**
   * the webserver hostname making this payment if available. Note: max chars 20, so you may need to truncate
   *
   * @param string $workstationId
   *
   * @return $this
   */
  public function setWorkstationId($workstationId)
  {
    $this->workstationId = $workstationId;
    return $this;
  }

  /**
   * <code>0</code> to indicate that the order will be collected at the box office, <code>1</code> to indicate that the
   * tickets will be posted out to the customers primary address, <code>2</code> to indicate that the tickets will be
   * posted to the customers alternative address and <code>3</code> to indicate that the tickets have been printed now
   * (outside of VIA)
   *
   * @return int
   */
  public function getDeliveryOption()
  {
    return $this->deliveryOption;
  }


  /**
   * <code>0</code> to indicate that the order will be collected at the box office, <code>1</code> to indicate that the
   * tickets will be posted out to the customers primary address, <code>2</code> to indicate that the tickets will be
   * posted to the customers alternative address and <code>3</code> to indicate that the tickets have been printed now
   * (outside of VIA)
   *
   * @param int $deliveryOption
   *
   * @return $this
   */
  public function setDeliveryOption($deliveryOption)
  {
    $this->deliveryOption = $deliveryOption;
    return $this;
  }

  /**
   * ID representing the customer making this payment
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * ID representing the customer making this payment
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
