<?php
/**
 * Defines the RawapiCompleteAccountOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method marks the account payment as paid or declined depending on the flag {@code paymentSuccess}.  If payment
 * was taken successfully all remote inventory servers in the order are dispatched with payment and order information.
 * If no errors occur then the basket in removed.   If the payment did not succeed then returning code will be a
 * paymentError allowing another payment to be attempted by   by starting the whole process again calling {@link
 * #apiCreateUnpaidAccountOrder(java.lang.String, java.lang.String, int, int, java.lang.String, java.lang.String)}  ->
 * process payment independently -> {@link #apiCompleteAccountOrder(String, boolean, String, String)}
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCompleteAccountOrderRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCompleteAccountOrderRequest.
 */
abstract class RawapiCompleteAccountOrderRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiCompleteAccountOrder';

  /**
   * the tracking reference used or returned from the independent payment processor. For example, a GUID.
   *
   * @var string
   */
  protected $paymentProcessorTrackingValue;

  /**
   * <code>true</code> to indicate that the account payment was taken successfully, <code>false</code> if the payment
   * failed
   *
   * @var bool
   */
  protected $paymentSuccess;

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * the authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the tracking reference used or returned from the independent payment processor. For example, a GUID.
   *
   * @return string
   */
  public function getPaymentProcessorTrackingValue()
  {
    return $this->paymentProcessorTrackingValue;
  }


  /**
   * the tracking reference used or returned from the independent payment processor. For example, a GUID.
   *
   * @param string $paymentProcessorTrackingValue
   *
   * @return $this
   */
  public function setPaymentProcessorTrackingValue($paymentProcessorTrackingValue)
  {
    $this->paymentProcessorTrackingValue = $paymentProcessorTrackingValue;
    return $this;
  }

  /**
   * <code>true</code> to indicate that the account payment was taken successfully, <code>false</code> if the payment
   * failed
   *
   * @return bool
   */
  public function getPaymentSuccess()
  {
    return $this->paymentSuccess;
  }


  /**
   * <code>true</code> to indicate that the account payment was taken successfully, <code>false</code> if the payment
   * failed
   *
   * @param bool $paymentSuccess
   *
   * @return $this
   */
  public function setPaymentSuccess($paymentSuccess)
  {
    $this->paymentSuccess = $paymentSuccess;
    return $this;
  }

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * the authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * the authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
