<?php
/**
 * Defines the ViaApiTicketRequest VIA data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\DataObject;

/**
 * @package    Red61\Via\DataObject
 * {@inheritdoc}
 */
class ViaApiTicketRequest extends \Red61\Via\RawGenerated\DataObject\RawViaApiTicketRequest {

	/**
	 * @param string $priceBandId  priceband ID to add tickets for
	 * @param string $concessionId concession ID (or 0 for full price)
	 * @param int    $quantity     number of tickets
	 */
	public function __construct($priceBandId, $concessionId, $quantity)
	{
		$this->priceBandId  = $priceBandId;
		$this->concessionId = $concessionId;
		$this->quantity     = $quantity;
	}

	/**
	 * @param \int[] $perferredSeats the seat IDs to request (from the seating plan)
	 *
	 * @return $this
	 */
	public function setPerferredSeats($perferredSeats)
	{
		$this->perferredSeats = $perferredSeats;
		return $this;
	}

	/**
	 * @param string $promoCode
	 *
	 * @return $this
	 */
	public function setPromoCode($promoCode)
	{
		$this->promoCode = $promoCode;
		return $this;
	}

}
