<?php
/**
 * Defines the ViaApiCustomerOtherDetails VIA data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\DataObject;

/**
 * This object is returned as part of the response from an apiGetCustomerDetails request, and can be used
 * as a parameter on the apiUpdateCustomerOtherDetails request to store changed details.
 *
 *    // Updating from the current details
 *    $other_details = $via
 *      ->getCustomerDetails(apiGetCustomerDetailsRequest::create()->setCustomerId($customer_id))
 *      ->getOtherdetails();
 *
 *    $other_details->setEvephone($new_phone);
 *    // and any other properties you wish to change
 *
 *    $via->updateCustomerOtherDetails(
 *        apiUpdateCustomerOtherDetailsRequest::create()
 *            ->setCustomerId($customer_id)
 *            ->setApiOtherDetails($other_details)
 *    );
 *
 * Alternatively, if you already have values for all the fields (eg from a form submission) you can create
 * a new instance with the appropriate customer ID.
 *
 *    // Overwriting all details
 *    $other_details = new ViaApiCustomerOtherDetails($customer_id);
 *
 *    $other_details->setEvephone($new_phone);
 *    // NB that you will need to set values for all fields, or any existing VIA data will be overwritten with blanks
 *
 *    $via->updateCustomerOtherDetails(
 *        apiUpdateCustomerOtherDetailsRequest::create()
 *            ->setCustomerId($customer_id)
 *            ->setApiOtherDetails($other_details)
 *    );
 *
 * @package    Red61\Via\DataObject
 * {@inheritdoc}
 */
class ViaApiCustomerOtherDetails extends \Red61\Via\RawGenerated\DataObject\RawViaApiCustomerOtherDetails {

	/**
	 * @param int $customerid
	 */
	public function __construct($customerid = NULL)
	{
		$this->customerid = $customerid;
	}

	/**
	 * @param string $dayphone
	 *
	 * @return $this
	 */
	public function setDayphone($dayphone)
	{
		$this->dayphone = $dayphone;
		return $this;
	}

	/**
	 * @param string $evephone
	 *
	 * @return $this
	 */
	public function setEvephone($evephone)
	{
		$this->evephone = $evephone;
		return $this;
	}

	/**
	 * @param string $fax
	 *
	 * @return $this
	 */
	public function setFax($fax)
	{
		$this->fax = $fax;
		return $this;
	}

	/**
	 * @param string $mobile
	 *
	 * @return $this
	 */
	public function setMobile($mobile)
	{
		$this->mobile = $mobile;
		return $this;
	}

	/**
	 * @param string $email
	 *
	 * @return $this
	 */
	public function setEmail($email)
	{
		$this->email = $email;
		return $this;
	}

	/**
	 * @param string $prefcontact
	 *
	 * @return $this
	 */
	public function setPrefcontact($prefcontact)
	{
		$this->prefcontact = $prefcontact;
		return $this;
	}

	/**
	 * @param string $altstreet1
	 *
	 * @return $this
	 */
	public function setAltstreet1($altstreet1)
	{
		$this->altstreet1 = $altstreet1;
		return $this;
	}

	/**
	 * @param string $altstreet2
	 *
	 * @return $this
	 */
	public function setAltstreet2($altstreet2)
	{
		$this->altstreet2 = $altstreet2;
		return $this;
	}

	/**
	 * @param string $altstreet3
	 *
	 * @return $this
	 */
	public function setAltstreet3($altstreet3)
	{
		$this->altstreet3 = $altstreet3;
		return $this;
	}

	/**
	 * @param string $altcity
	 *
	 * @return $this
	 */
	public function setAltcity($altcity)
	{
		$this->altcity = $altcity;
		return $this;
	}

	/**
	 * @param string $altcounty
	 *
	 * @return $this
	 */
	public function setAltcounty($altcounty)
	{
		$this->altcounty = $altcounty;
		return $this;
	}

	/**
	 * @param string $altcountry
	 *
	 * @return $this
	 */
	public function setAltcountry($altcountry)
	{
		$this->altcountry = $altcountry;
		return $this;
	}

	/**
	 * @param string $altpobox
	 *
	 * @return $this
	 */
	public function setAltpobox($altpobox)
	{
		$this->altpobox = $altpobox;
		return $this;
	}

	/**
	 * @param string $altstate
	 *
	 * @return $this
	 */
	public function setAltstate($altstate)
	{
		$this->altstate = $altstate;
		return $this;
	}

	/**
	 * @param string $altpostcode
	 *
	 * @return $this
	 */
	public function setAltpostcode($altpostcode)
	{
		$this->altpostcode = $altpostcode;
		return $this;
	}

}
