<?php
/**
 * Defines the RawViaApiMerchandiseDetails data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Represents the amount and value of this merchandise variation within the order
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiMerchandiseDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiMerchandiseDetails.
 */
abstract class RawViaApiMerchandiseDetails {

  /**
   * The reference of the merchandise this basket item represents in the form "serverId:merchandiseId"
   *
   * @var string
   */
  protected $merchandiseRef;

  /**
   * The code of the merchandise.
   *
   * @var string
   */
  protected $merchandiseCode;

  /**
   * The title of the merchandise.
   *
   * @var string
   */
  protected $merchandiseTitle;

  /**
   * The reference of the variation this item represents in the form "serverId:variationId"
   *
   * @var string
   */
  protected $variationRef;

  /**
   * The code of this variation.
   *
   * @var string
   */
  protected $variationCode;

  /**
   * The title of this variation.
   *
   * @var string
   */
  protected $variationTitle;

  /**
   * The cost of a single variation.
   *
   * @var double
   */
  protected $value;

  /**
   * The number of this variation in the order.
   *
   * @var int
   */
  protected $quantity;

  /**
   * See `ViaApiMerchandiseVariation#defaultVariation`
   *
   * @var bool
   */
  protected $defaultVariation;

  /**
   * The value of the tax on this group of merchandise
   *
   * @var double
   */
  protected $groupTaxValue;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'merchandiseRef':
        return $this->getMerchandiseRef();
      case 'merchandiseCode':
        return $this->getMerchandiseCode();
      case 'merchandiseTitle':
        return $this->getMerchandiseTitle();
      case 'variationRef':
        return $this->getVariationRef();
      case 'variationCode':
        return $this->getVariationCode();
      case 'variationTitle':
        return $this->getVariationTitle();
      case 'value':
        return $this->getValue();
      case 'quantity':
        return $this->getQuantity();
      case 'defaultVariation':
        return $this->getDefaultVariation();
      case 'groupTaxValue':
        return $this->getGroupTaxValue();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of the merchandise this basket item represents in the form "serverId:merchandiseId"
   *
   * @return string
   */
  public function getMerchandiseRef()
  {
    return $this->merchandiseRef;
  }


  /**
   * The code of the merchandise.
   *
   * @return string
   */
  public function getMerchandiseCode()
  {
    return $this->merchandiseCode;
  }


  /**
   * The title of the merchandise.
   *
   * @return string
   */
  public function getMerchandiseTitle()
  {
    return $this->merchandiseTitle;
  }


  /**
   * The reference of the variation this item represents in the form "serverId:variationId"
   *
   * @return string
   */
  public function getVariationRef()
  {
    return $this->variationRef;
  }


  /**
   * The code of this variation.
   *
   * @return string
   */
  public function getVariationCode()
  {
    return $this->variationCode;
  }


  /**
   * The title of this variation.
   *
   * @return string
   */
  public function getVariationTitle()
  {
    return $this->variationTitle;
  }


  /**
   * The cost of a single variation.
   *
   * @return double
   */
  public function getValue()
  {
    return $this->value;
  }


  /**
   * The number of this variation in the order.
   *
   * @return int
   */
  public function getQuantity()
  {
    return $this->quantity;
  }


  /**
   * See `ViaApiMerchandiseVariation#defaultVariation`
   *
   * @return bool
   */
  public function getDefaultVariation()
  {
    return $this->defaultVariation;
  }


  /**
   * The value of the tax on this group of merchandise
   *
   * @return double
   */
  public function getGroupTaxValue()
  {
    return $this->groupTaxValue;
  }


}
