<?php
/**
 * Defines the RawapiSetRefundExemptRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method takes a list of tickets identified by `ViaApiItemRefundExemptRequest#itemId` within the transaction and
 * marks them as refund exempt or not depending on `ViaApiItemRefundExemptRequest#refundExemptCode` value.
 * 
 * NOTE this will **override** whatever refund exempt code values were previously stored against these tickets.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSetRefundExemptRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSetRefundExemptRequest.
 */
abstract class RawapiSetRefundExemptRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiSetRefundExempt';

  /**
   * the ID of the customer who must match the customer of the transaction
   *
   * @var int
   */
  protected $customerId;

  /**
   * the order id of the transaction the tickets are from\
   *
   * @var string
   */
  protected $orderId;

  /**
   * the tickets to change the refund exempt status for
   *
   * @var \Red61\Via\DataObject\ViaApiItemRefundExemptRequest[]
   */
  protected $refundExemptItems;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the ID of the customer who must match the customer of the transaction
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * the ID of the customer who must match the customer of the transaction
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * the order id of the transaction the tickets are from\
   *
   * @return string
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * the order id of the transaction the tickets are from\
   *
   * @param string $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * the tickets to change the refund exempt status for
   *
   * @return \Red61\Via\DataObject\ViaApiItemRefundExemptRequest[]
   */
  public function getRefundExemptItems()
  {
    return $this->refundExemptItems;
  }


  /**
   * the tickets to change the refund exempt status for
   *
   * @param \Red61\Via\DataObject\ViaApiItemRefundExemptRequest[] $refundExemptItems
   *
   * @return $this
   */
  public function setRefundExemptItems($refundExemptItems)
  {
    $this->refundExemptItems = $refundExemptItems;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
