<?php
/**
 * Defines Red61\Via\CircuitBreaker\ViaCircuitBreakerPlugin
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Edinburgh International Book Festival Ltd
 * @licence   http://opensource.org/licenses/BSD-3-Clause
 */

namespace Red61\Via\CircuitBreaker;

/**
 * The ViaCircuitBreaker protects your application by detecting outages and periods of
 * elevated VIA error rates, and blocking subsequent API calls until the system returns
 * to normal. See the package README.md for complete documentation.
 *
 * @package Red61\Via\CircuitBreaker
 * @see     spec\Red61\Via\CircuitBreaker\ViaCircuitBreakerPluginSpec
 */
interface ViaCircuitBreaker {

	const SEVERITY_CRITICAL = 'critical';
	const SEVERITY_WARNING = 'warning';

	/**
	 * @return bool
	 */
	public function isTripped();

	/**
	 * @param string     $severity  One of the severity constants
	 * @param \Exception $exception The error thrown by the VIA client
	 *
	 * @return void
	 */
	public function notifyFailure($severity, \Exception $exception);

	/**
	 * @return bool
	 */
	public function requestPermissionToCall();

	/**
	 * @return void
	 */
	public function reset();
}
