<?php
/**
 * Holds the default VIA cache TTL configuration
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\Cache;


/**
 * Defines the default cache TTL for each API method, based on the cache policies defined by VIA. To
 * customise TTL for your own application, see the constructor options for the ViaCachePlugin.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here.
 *
 * [!!] VIA internally caches most calls based on the same policies that define these TTLs. Customising your
 *      application to use a shorter TTL may not have any effect other than increasing load on the VIA server.
 *
 * @package Red61\Via\Cache
 */
class ViaCacheTTLConfig {

	/**
	 * @var int[] default ttl for methods, as an array by SOAP method name
	 */
	public static $default_ttl = array(
		'apiAddCustomerCategory' => 0,
		'apiAddDonationToBasket' => 0,
		'apiAddMerchandiseToBasket' => 0,
		'apiAddOrderNote' => 0,
		'apiAddPerformanceAccessNotesToBasket' => 0,
		'apiAddPromocodeToBasket' => 0,
		'apiAddSchemeToBasket' => 0,
		'apiAddTicketsToBasket' => 0,
		'apiAddTicketsWithAttributesToBasket' => 0,
		'apiAddVoucherTypeToBasket' => 0,
		'apiAnswerQuestionnaire' => 0,
		'apiBasketKeepAlive' => 0,
		'apiCheckPasswordResetTokenValidity' => 0,
		'apiClaimFromFriend' => 0,
		'apiCleanUnpaidOrder' => 0,
		'apiClearBasket' => 0,
		'apiCompleteAccountOrder' => 0,
		'apiCompleteOrder' => 0,
		'apiConvertReservation' => 0,
		'apiCreateAccount' => 0,
		'apiCreateCardPaymentOrder' => 0,
		'apiCreateGiftAidDeclaration' => 0,
		'apiCreateInitialUnpaidOrder' => 0,
		'apiCreateMedia' => 0,
		'apiCreateOrder' => 0,
		'apiCreateRepeatPaymentOrder' => 0,
		'apiCreateReservation' => 0,
		'apiCreateUnpaidAccountOrder' => 0,
		'apiCustomerEmailExists' => 0,
		'apiCustomerEmailVerifiedActive' => 0,
		'apiCustomerPasswordReset' => 0,
		'apiDeclineQuestionnaire' => 0,
		'apiDoesProcessorSupportRepeatPayments' => 604800,
		'apiEventDetailedSearch' => 3600,
		'apiEventQuickSearch' => 3600,
		'apiFilterEvents' => 3600,
		'apiFilterEventsByTime' => 3600,
		'apiGetAccessNoteCategories' => 0,
		'apiGetAccreditationByCustomerAndType' => 0,
		'apiGetAccreditationTypes' => 1800,
		'apiGetActiveSeasons' => 3600,
		'apiGetAddress' => 604800,
		'apiGetArtists' => 3600,
		'apiGetBasketItems' => 0,
		'apiGetBasketLimits' => 0,
		'apiGetBasketOrderNotes' => 0,
		'apiGetBasketPrintOptions' => 0,
		'apiGetBasketSessionId' => 0,
		'apiGetBasketSuggestedDonations' => 0,
		'apiGetBasketSummary' => 0,
		'apiGetCardTypeFromBIN' => 604800,
		'apiGetConsentQuestionsForBasket' => 0,
		'apiGetConsentQuestionsForExistingCustomer' => 0,
		'apiGetConsentQuestionsForNewCustomer' => 3600,
		'apiGetCountries' => 604800,
		'apiGetCountryDetails' => 604800,
		'apiGetCustomCustomerFields' => 0,
		'apiGetCustomerCategories' => 0,
		'apiGetCustomerCompanyDetails' => 0,
		'apiGetCustomerConsentQuestions' => 0,
		'apiGetCustomerDetails' => 0,
		'apiGetCustomerDigitalAssets' => 0,
		'apiGetCustomerFriendStatus' => 0,
		'apiGetCustomerGiftAidDeclaration' => 0,
		'apiGetCustomerGiftAidDeclarations' => 1800,
		'apiGetCustomerInterestsEvent' => 0,
		'apiGetCustomerInterestsPerformance' => 0,
		'apiGetCustomerJWT' => 0,
		'apiGetCustomerName' => 0,
		'apiGetCustomerSavedCards' => 0,
		'apiGetCustomerSchemeUsages' => 0,
		'apiGetCustomerSchemes' => 0,
		'apiGetCustomerSubscriptionDetails' => 0,
		'apiGetCustomerTransactionsSummary' => 0,
		'apiGetCustomerTransactionsSummaryByDate' => 0,
		'apiGetCustomerUndecidedMailPermissionCompanies' => 0,
		'apiGetCustomerVouchers' => 0,
		'apiGetDayChangeOffset' => 604800,
		'apiGetDeliveryOptions' => 0,
		'apiGetDisplayableQuestionnaires' => 0,
		'apiGetDonationFunds' => 3600,
		'apiGetDonationsForEvent' => 1800,
		'apiGetEventAgeSuitabilities' => 604800,
		'apiGetEventDetails' => 1800,
		'apiGetEventTags' => 3600,
		'apiGetEventTypes' => 3600,
		'apiGetEvents' => 3600,
		'apiGetGiftAidText' => 604800,
		'apiGetHPHPerformances' => 0,
		'apiGetMedia' => 0,
		'apiGetMerchandise' => 3600,
		'apiGetMerchandiseByCategory' => 3600,
		'apiGetMerchandiseCategories' => 3600,
		'apiGetMyClaimedTickets' => 0,
		'apiGetOfferPerformances' => 0,
		'apiGetOrderDonationDetails' => 0,
		'apiGetOrderIdForSessionId' => 0,
		'apiGetOrderSchemeDetails' => 0,
		'apiGetOrderSummary' => 0,
		'apiGetOrderTicketDetails' => 0,
		'apiGetOrderTicketDetailsWithStatus' => 0,
		'apiGetPerformanceAvailability' => 0,
		'apiGetPerformanceAvailabilityList' => 0,
		'apiGetPerformanceDates' => 1800,
		'apiGetPerformanceDetails' => 1800,
		'apiGetPerformancePrices' => 1800,
		'apiGetPerformances' => 1800,
		'apiGetPerformancesByDate' => 1800,
		'apiGetPerformancesByScheme' => 1800,
		'apiGetPerformancesByTime' => 1800,
		'apiGetPostageCharges' => 1800,
		'apiGetPresentationFormats' => 3600,
		'apiGetPriceBandAvailability' => 0,
		'apiGetQuestionnaireDetails' => 0,
		'apiGetQuestionnaireResponseByQuestionnaireAndCustomer' => 0,
		'apiGetSchemeDetails' => 3600,
		'apiGetSchemeTierDetails' => 3600,
		'apiGetSchemes' => 1800,
		'apiGetSeatingPlan' => 0,
		'apiGetSubVenueDetails' => 3600,
		'apiGetSubVenues' => 3600,
		'apiGetTicketsByClaimToken' => 0,
		'apiGetTransactionDetails' => 0,
		'apiGetUserSimilarEvents' => 0,
		'apiGetVenueDetails' => 3600,
		'apiGetVenues' => 3600,
		'apiGetVersion' => 0,
		'apiGetVoucherGiftDetailsForOrder' => 0,
		'apiGetVoucherTypes' => 3600,
		'apiIsPostAllowed' => 0,
		'apiListSentByFriend' => 0,
		'apiLogin' => 0,
		'apiMarkVoucherAsGifted' => 0,
		'apiRedeemVoucher' => 0,
		'apiRefundCompItems' => 0,
		'apiRegisterInterestInEvent' => 0,
		'apiRegisterInterestInPerformance' => 0,
		'apiReleaseTicketsFromReservation' => 0,
		'apiRemoveCustomerCategory' => 0,
		'apiRemoveDonationFromBasket' => 0,
		'apiRemoveMerchandiseFromBasket' => 0,
		'apiRemovePerformanceAccessNotesFromBasket' => 0,
		'apiRemoveRepeatabilityCustomerSavedCard' => 0,
		'apiRemoveSchemeFromBasket' => 0,
		'apiRemoveTicket' => 0,
		'apiRemoveVoucherRedeemFromBasket' => 0,
		'apiRemoveVoucherRedeemsFromBasket' => 0,
		'apiRemoveVoucherTypeFromBasket' => 0,
		'apiRemoveVoucherTypesFromBasket' => 0,
		'apiSaveCardDetails' => 0,
		'apiSearchAddress' => 604800,
		'apiSend3DSecureReturn' => 0,
		'apiSendCardPaymentReturn' => 0,
		'apiSendConfirmationEmail' => 0,
		'apiSendPasswordResetEmail' => 0,
		'apiSendPasswordResetEmailByCustomerId' => 0,
		'apiSendToAFriend' => 0,
		'apiSetAffiliate' => 0,
		'apiSetBasketCustomer' => 0,
		'apiSetBasketOrderNote' => 0,
		'apiSetCampaignTrackingId' => 0,
		'apiSetCreateGiftAidDeclaration' => 0,
		'apiSetCustomerCategories' => 0,
		'apiSetCustomerConsentAnswers' => 0,
		'apiSetCustomerFriendStatus' => 0,
		'apiSetDeliveryOption' => 0,
		'apiSetPostageCharge' => 0,
		'apiSetRefundExempt' => 0,
		'apiSubmitAccreditation' => 0,
		'apiUpdateCustomerAccessRequirement' => 0,
		'apiUpdateCustomerCompanyMailPermissions' => 0,
		'apiUpdateCustomerCustomFields' => 0,
		'apiUpdateCustomerOtherDetails' => 0,
		'apiUpdateCustomerPassword' => 0,
		'apiUpdateTicketConcession' => 0,
		'apiUpdateWheelChairTicketsInBasket' => 0,
	);
} 
