<?php


namespace Red61\Via\Cache;


class CacheConfigurationException extends \RuntimeException
{

    /**
     * @return CacheConfigurationException
     */
    public static function missingHost()
    {
        return new static('Cannot connect to memcached without a `host` option');
    }

    /**
     * @return CacheConfigurationException
     */
    public static function unexpectedServers()
    {
        return new static(
            'Unexpected existing memcached connections - pass `server=>NULL` to ' . ViaMemcachedDriver::class . ' if you are managing your own connection pool'
        );
    }

    /**
     * @param string $host
     * @param string $port
     *
     * @return CacheConfigurationException
     */
    public static function addServerFailed($host, $port)
    {
        return new static(
            sprintf(
                'Failed to add `%s:%s` to the memcached server pool',
                $host,
                $port
            )
        );
    }

    /**
     * @param int   $option
     * @param mixed $value
     *
     * @return CacheConfigurationException
     */
    public static function setOptionFailed($option, $value)
    {
        return new static(
            sprintf(
                'Failed to set memcached option `%s` to `%s`',
                $option,
                $value
            )
        );
    }
}