<?php
/**
 * Defines the RawapiSendCardPaymentReturnRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Completes the order and payment flow after a successful payment has been taken by the Payment Service Provider. This
 * method persists the payment information to the database, and completes the order depending on whether the payment was
 * taken successfully or not. If payment was taken successfully all remote inventory servers in the order are dispatched
 * with payment and order information. If no errors occur then the basket in removed. If the payment did not succeed
 * then returning code will be a paymentError allowing another payment to be attempted by by starting the whole process
 * again calling `apiCreateCardPaymentOrder`
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSendCardPaymentReturnRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSendCardPaymentReturnRequest.
 */
abstract class RawapiSendCardPaymentReturnRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiSendCardPaymentReturn';

  /**
   * Any additionalData that may be passed back e.g token for the card details
   *
   * @var \Red61\Via\DataObject\ViaApiKeyValuePair[]
   */
  protected $responseParams;

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * Any additionalData that may be passed back e.g token for the card details
   *
   * @return \Red61\Via\DataObject\ViaApiKeyValuePair[]
   */
  public function getResponseParams()
  {
    return $this->responseParams;
  }


  /**
   * Any additionalData that may be passed back e.g token for the card details
   *
   * @param \Red61\Via\DataObject\ViaApiKeyValuePair[] $responseParams
   *
   * @return $this
   */
  public function setResponseParams($responseParams)
  {
    $this->responseParams = $responseParams;
    return $this;
  }

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
