<?php
namespace oasis\names\specification\ubl\schema\xsd\QualifiedDatatypes_2;

use un\unece\uncefact\data\specification\UnqualifiedDataTypesSchemaModule\_2;
/**
 * @xmlNamespace urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2
 * @xmlType CodeType
 * @xmlName TransportationStatusCodeType
 * @var oasis\names\specification\ubl\schema\xsd\QualifiedDatatypes_2\TransportationStatusCodeType
 * @xmlDictionaryEntryName Transportation Status_ Code. Type
 * @xmlVersion 2.0
 * @xmlDefinition The set of code values for Trade and Transport Status
 * @xmlRepresentationTerm Code
 * @xmlQualifierTerm Transportation Status
 */
class TransportationStatusCodeType
	extends _2\CodeType
	{

	
	/**
	 * @Name Transportation Status_ Code List. Identifier
	 * @Definition 
	 * @PrimitiveType String
	 * @xmlType attribute
	 * @xmlName listID
	 * @var string
	 */
	public $listID;
	/**
	 * @Name Transportation Status_ Code List. Agency. Identifier
	 * @Definition 
	 * @PrimitiveType String
	 * @xmlType attribute
	 * @xmlName listAgencyID
	 * @var string
	 */
	public $listAgencyID;
	/**
	 * @Name Transportation Status_ Code List. Agency Name. Text
	 * @Definition 
	 * @PrimitiveType String
	 * @xmlType attribute
	 * @xmlName listAgencyName
	 * @var string
	 */
	public $listAgencyName;
	/**
	 * @Name Transportation Status_ Code List. Name. Text
	 * @Definition 
	 * @PrimitiveType String
	 * @xmlType attribute
	 * @xmlName listName
	 * @var string
	 */
	public $listName;
	/**
	 * @Name Transportation Status_ Code List. Version. Identifier
	 * @Definition 
	 * @PrimitiveType String
	 * @xmlType attribute
	 * @xmlName listVersionID
	 * @var string
	 */
	public $listVersionID;
	/**
	 * @Name Transportation Status_ Code. Name. Text
	 * @Definition 
	 * @PrimitiveType String
	 * @xmlType attribute
	 * @xmlName name
	 * @var string
	 */
	public $name;
	/**
	 * @Name Transportation Status_ Language. Identifier
	 * @Definition 
	 * @PrimitiveType String
	 * @xmlType attribute
	 * @xmlName languageID
	 * @var string
	 */
	public $languageID;
	/**
	 * @Name Transportation Status_ Code List. Uniform Resource. Identifier
	 * @Definition 
	 * @PrimitiveType String
	 * @xmlType attribute
	 * @xmlName listURI
	 * @var string
	 */
	public $listURI;
	/**
	 * @Name Transportation Status_ Code List Scheme. Uniform Resource. Identifier
	 * @Definition 
	 * @PrimitiveType String
	 * @xmlType attribute
	 * @xmlName listSchemeURI
	 * @var string
	 */
	public $listSchemeURI;


} // end class TransportationStatusCodeType
