<?php
namespace QuickBooksOnline\API\Data;
/**
 * @xmlNamespace http://schema.intuit.com/finance/v3
 * @xmlType
 * @xmlName IPPUOMConvUnit
 * @var IPPUOMConvUnit
 * @xmlDefinition Related UOM
 */
class IPPUOMConvUnit
	{

		/**
		* Initializes this object, optionally with pre-defined property values
		*
		* Initializes this object and it's property members, using the dictionary
		* of key/value pairs passed as an optional argument.
		*
		* @param dictionary $keyValInitializers key/value pairs to be populated into object's properties
		* @param boolean $verbose specifies whether object should echo warnings
		*/
		public function __construct($keyValInitializers=array(), $verbose=FALSE)
		{
			foreach($keyValInitializers as $initPropName => $initPropVal)
			{
				if (property_exists('IPPUOMConvUnit',$initPropName)|| property_exists('QuickBooksOnline\API\Data\IPPUOMConvUnit',$initPropName))
				{
					$this->{$initPropName} = $initPropVal;
				}
				else
				{
					if ($verbose)
						echo "Property does not exist ($initPropName) in class (".get_class($this).")";
				}
			}
		}


	/**
	 * @Definition User recognizable name of the Unit of Measure.[br /]
						 [br /]
						Required for the create operation. [br /]
						Max Length: 31

	 * @xmlType element
	 * @xmlNamespace http://schema.intuit.com/finance/v3
	 * @xmlMinOccurs 0
	 * @xmlName Name
	 * @var string
	 */
	public $Name;
	/**
	 * @Definition Abbreviation of the Unit of Measure.[br /]
						 [br /]
						Required for the create operation. [br /]
						Max Length: 31

	 * @xmlType element
	 * @xmlNamespace http://schema.intuit.com/finance/v3
	 * @xmlMinOccurs 0
	 * @xmlName Abbrv
	 * @var string
	 */
	public $Abbrv;
	/**
	 * @xmlType element
	 * @xmlNamespace http://schema.intuit.com/finance/v3
	 * @xmlMinOccurs 0
	 * @xmlName ConvRatio
	 * @var float
	 */
	public $ConvRatio;


} // end class IPPUOMConvUnit
