<?php
namespace QuickBooksOnline\API\Data;

/**
 * @xmlNamespace http://schema.intuit.com/finance/v3
 * @xmlType string
 * @xmlName IPPTaxFormTypeEnum
 * @var IPPTaxFormTypeEnum
 * @xmlDefinition 
				Product: QBO
				Description: Tax Form Type holds data related to Tax Information (Tax Form Type)
				based on Regional compliance laws. Applicable for IN region
				currently. Can be used to extend for other Regions.
			
 */
class IPPTaxFormTypeEnum
	{

		/**                                                                       
		* Initializes this object, optionally with pre-defined property values    
		*                                                                         
		* Initializes this object and it's property members, using the dictionary
		* of key/value pairs passed as an optional argument.                      
		*                                                                         
		* @param array $keyValInitializers key/value pairs to be populated into object's properties 
		* @param boolean $verbose specifies whether object should echo warnings   
		*/                                                                        
		public function __construct($keyValInitializers=array(), $verbose=FALSE)
		{
			foreach($keyValInitializers as $initPropName => $initPropVal)
			{
				if (property_exists('IPPTaxFormTypeEnum',$initPropName) || property_exists('QuickBooksOnline\API\Data\IPPTaxFormTypeEnum',$initPropName))
				{
					$this->{$initPropName} = $initPropVal;
				}
				else
				{
					if ($verbose)
						echo "Property does not exist ($initPropName) in class (".get_class($this).")";
				}
			}
		}

		/**
		 * @xmlType value
		 * @var string
		 */
		public $value;

} // end class IPPTaxFormTypeEnum
