<?php
namespace QuickBooksOnline\API\Data;

/**
 * @xmlNamespace http://schema.intuit.com/finance/v3
 * @xmlType 
 * @xmlName IPPGroupLineDetail
 * @var IPPGroupLineDetail
 * @xmlDefinition 
				Product: ALL
				Description: Detail for a group item
				line, including the lines expanded from the group item.
			
 */
class IPPGroupLineDetail
	{

		/**                                                                       
		* Initializes this object, optionally with pre-defined property values    
		*                                                                         
		* Initializes this object and it's property members, using the dictionary
		* of key/value pairs passed as an optional argument.                      
		*                                                                         
		* @param array $keyValInitializers key/value pairs to be populated into object's properties 
		* @param boolean $verbose specifies whether object should echo warnings   
		*/                                                                        
		public function __construct($keyValInitializers=array(), $verbose=FALSE)
		{
			foreach($keyValInitializers as $initPropName => $initPropVal)
			{
				if (property_exists('IPPGroupLineDetail',$initPropName) || property_exists('QuickBooksOnline\API\Data\IPPGroupLineDetail',$initPropName))
				{
					$this->{$initPropName} = $initPropVal;
				}
				else
				{
					if ($verbose)
						echo "Property does not exist ($initPropName) in class (".get_class($this).")";
				}
			}
		}

	
	/**
	 * @Definition 
						Product: ALL
						Description: Reference to a group
						item for all the lines that belong to the group.
					
	 * @xmlType element
	 * @xmlNamespace 
	 * @xmlName GroupItemRef
	 * @var IPPReferenceType
	 */
	public $GroupItemRef;
	/**
	 * @Definition 
						Product: ALL
						Description: Quantity of the group
						item.
					
	 * @xmlType element
	 * @xmlNamespace 
	 * @xmlMinOccurs 0
	 * @xmlName Quantity
	 * @var float
	 */
	public $Quantity;
	/**
	 * @Definition 
						Product: ALL
						Description: Unit of Measure
						reference.
					
	 * @xmlType element
	 * @xmlNamespace 
	 * @xmlMinOccurs 0
	 * @xmlName UOMRef
	 * @var IPPUOMRef
	 */
	public $UOMRef;
	/**
	 * @Definition 
						Product: ALL
						Description: Date when the service is
						performed.
					
	 * @xmlType element
	 * @xmlNamespace 
	 * @xmlMinOccurs 0
	 * @xmlName ServiceDate
	 * @var string
	 */
	public $ServiceDate;
	/**
	 * @Definition 
						Product: ALL
						Description: The list of lines
						expanded from the group item. Note that a group line cannot itself
						contain group lines.
					
	 * @xmlType element
	 * @xmlNamespace 
	 * @xmlMinOccurs 0
	 * @xmlMaxOccurs unbounded
	 * @xmlName Line
	 * @var IPPLine
	 */
	public $Line;
	/**
	 * @Definition 
						Product: ALL
						Description: Internal use only:
						extension place holder for GroupLineDetail
					
	 * @xmlType element
	 * @xmlNamespace 
	 * @xmlMinOccurs 0
	 * @xmlMaxOccurs 1
	 * @xmlName GroupLineDetailEx
	 * @var IPPIntuitAnyType
	 */
	public $GroupLineDetailEx;


} // end class IPPGroupLineDetail
