<?php
namespace QuickBooksOnline\API\Data;
/**
 * @xmlNamespace http://schema.intuit.com/finance/v3
 * @xmlType
 * @xmlName IPPPrintDocumentPrefs
 * @var IPPPrintDocumentPrefs
 * @xmlDefinition Defines Messages Prefs details
 */
class IPPPrintDocumentPrefs
	{

		/**
		* Initializes this object, optionally with pre-defined property values
		*
		* Initializes this object and it's property members, using the dictionary
		* of key/value pairs passed as an optional argument.
		*
		* @param dictionary $keyValInitializers key/value pairs to be populated into object's properties
		* @param boolean $verbose specifies whether object should echo warnings
		*/
		public function __construct($keyValInitializers=array(), $verbose=FALSE)
		{
			foreach($keyValInitializers as $initPropName => $initPropVal)
			{
				if (property_exists('IPPPrintDocumentPrefs',$initPropName)|| property_exists('QuickBooksOnline\API\Data\IPPPrintDocumentPrefs',$initPropName))
				{
					$this->{$initPropName} = $initPropVal;
				}
				else
				{
					if ($verbose)
						echo "Property does not exist ($initPropName) in class (".get_class($this).")";
				}
			}
		}


	/**
	 * @Definition  Specifies Preferences classified as email messages are classified as Name-Value pair

	 * @xmlType element
	 * @xmlNamespace http://schema.intuit.com/finance/v3
	 * @xmlMinOccurs 0
	 * @xmlMaxOccurs unbounded
	 * @xmlName NameValue
	 * @var com\intuit\schema\finance\v3\IPPNameValue
	 */
	public $NameValue;


} // end class IPPPrintDocumentPrefs
