<?php
namespace QuickBooksOnline\API\Data;

/**
 * @xmlNamespace http://schema.intuit.com/finance/v3
 * @xmlType
 * @xmlName IPPItemGroupDetail
 * @var IPPItemGroupDetail
 * @xmlDefinition
                Product: ALL
                Description: Contains the details of a group item.

 */
class IPPItemGroupDetail
{

        /**
        * Initializes this object, optionally with pre-defined property values
        *
        * Initializes this object and it's property members, using the dictionary
        * of key/value pairs passed as an optional argument.
        *
        * @param dictionary $keyValInitializers key/value pairs to be populated into object's properties
        * @param boolean $verbose specifies whether object should echo warnings
        */
        public function __construct($keyValInitializers=array(), $verbose=false)
        {
            foreach ($keyValInitializers as $initPropName => $initPropVal) {
                if (property_exists('IPPItemGroupDetail', $initPropName)|| property_exists('QuickBooksOnline\API\Data\IPPItemGroupDetail', $initPropName)) {
                    $this->{$initPropName} = $initPropVal;
                } else {
                    if ($verbose) {
                        echo "Property does not exist ($initPropName) in class (".get_class($this).")";
                    }
                }
            }
        }


    /**
     * @Definition
                            Product: ALL
                            Description: Contains the line details of a group item.

     * @xmlType element
     * @xmlNamespace http://schema.intuit.com/finance/v3
     * @xmlMinOccurs 0
     * @xmlMaxOccurs unbounded
     * @xmlName ItemGroupLine
     * @var com\intuit\schema\finance\v3\IPPItemComponentLine
     */
    public $ItemGroupLine;
} // end class IPPItemGroupDetail
