<?php
namespace Phpforce\SoapClient;

use Phpforce\SoapClient\Soap\SoapClientFactory;
use Phpforce\SoapClient\Plugin\LogPlugin;
use Phpi\Log\LogInterface;

/**
 * Salesforce SOAP client builder
 */
class ClientBuilder
{
    protected $log;

    /**
     * Construct client builder with required parameters
     *
     * @param string $wsdl     Path to your Salesforce WSDL
     * @param string $username Your Salesforce username
     * @param string $password Your Salesforce password
     * @param string $token    Your Salesforce security token
     */
    public function __construct($wsdl, $username, $password, $token)
    {
        $this->wsdl = $wsdl;
        $this->username = $username;
        $this->password = $password;
        $this->token = $token;
    }

    /**
     * Enable logging
     *
     * @param LogInterface $log Logger
     *
     * @return ClientBuilder
     */
    public function withLog(LogInterface $log)
    {
        $this->log = $log;

        return $this;
    }

    /**
     * Build the Salesforce SOAP client
     *
     * @return Client
     */
    public function build()
    {
        $soapClientFactory = new SoapClientFactory();
        $soapClient = $soapClientFactory->factory($this->wsdl);

        $client = new Client($soapClient, $this->username, $this->password, $this->token);

        if ($this->log) {
            $logPlugin = new LogPlugin($this->log);
            $client->getEventDispatcher()->addSubscriber($logPlugin);
        }

        return $client;
    }
}

