<?php
/**
 * FeesEstimateResult
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Product Fees
 *
 * The Selling Partner API for Product Fees lets you programmatically retrieve estimated fees for a product. You can then account for those fees in your pricing.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FeesV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * FeesEstimateResult Class Doc Comment
 *
 * @category Class
 * @description An item identifier and the estimated fees for the item.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class FeesEstimateResult extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FeesEstimateResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'status' => 'string',
        'fees_estimate_identifier' => '\SellingPartnerApi\Model\FeesV0\FeesEstimateIdentifier',
        'fees_estimate' => '\SellingPartnerApi\Model\FeesV0\FeesEstimate',
        'error' => '\SellingPartnerApi\Model\FeesV0\FeesEstimateError'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'status' => null,
        'fees_estimate_identifier' => null,
        'fees_estimate' => null,
        'error' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'status' => 'Status',
        'fees_estimate_identifier' => 'FeesEstimateIdentifier',
        'fees_estimate' => 'FeesEstimate',
        'error' => 'Error'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'status' => 'setStatus',
        'fees_estimate_identifier' => 'setFeesEstimateIdentifier',
        'fees_estimate' => 'setFeesEstimate',
        'error' => 'setError'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'status' => 'getStatus',
        'fees_estimate_identifier' => 'getFeesEstimateIdentifier',
        'fees_estimate' => 'getFeesEstimate',
        'error' => 'getError'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['status'] = $data['status'] ?? null;
        $this->container['fees_estimate_identifier'] = $data['fees_estimate_identifier'] ?? null;
        $this->container['fees_estimate'] = $data['fees_estimate'] ?? null;
        $this->container['error'] = $data['error'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status The status of the fee request. Possible values: Success, ClientError, ServiceError.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }
    /**
     * Gets fees_estimate_identifier
     *
     * @return \SellingPartnerApi\Model\FeesV0\FeesEstimateIdentifier|null
     */
    public function getFeesEstimateIdentifier()
    {
        return $this->container['fees_estimate_identifier'];
    }

    /**
     * Sets fees_estimate_identifier
     *
     * @param \SellingPartnerApi\Model\FeesV0\FeesEstimateIdentifier|null $fees_estimate_identifier fees_estimate_identifier
     *
     * @return self
     */
    public function setFeesEstimateIdentifier($fees_estimate_identifier)
    {
        $this->container['fees_estimate_identifier'] = $fees_estimate_identifier;

        return $this;
    }
    /**
     * Gets fees_estimate
     *
     * @return \SellingPartnerApi\Model\FeesV0\FeesEstimate|null
     */
    public function getFeesEstimate()
    {
        return $this->container['fees_estimate'];
    }

    /**
     * Sets fees_estimate
     *
     * @param \SellingPartnerApi\Model\FeesV0\FeesEstimate|null $fees_estimate fees_estimate
     *
     * @return self
     */
    public function setFeesEstimate($fees_estimate)
    {
        $this->container['fees_estimate'] = $fees_estimate;

        return $this;
    }
    /**
     * Gets error
     *
     * @return \SellingPartnerApi\Model\FeesV0\FeesEstimateError|null
     */
    public function getError()
    {
        return $this->container['error'];
    }

    /**
     * Sets error
     *
     * @param \SellingPartnerApi\Model\FeesV0\FeesEstimateError|null $error error
     *
     * @return self
     */
    public function setError($error)
    {
        $this->container['error'] = $error;

        return $this;
    }
}


