<?php

/**
 * This file is auto-generated by Saloon SDK Generator
 * Generator: SellingPartnerApi\Generator\Generators\RequestGenerator
 * Do not modify it directly.
 */

declare(strict_types=1);

namespace SellingPartnerApi\Seller\NotificationsV1\Requests;

use Exception;
use Saloon\Enums\Method;
use Saloon\Http\Response;
use SellingPartnerApi\Enums\GrantlessScope;
use SellingPartnerApi\Middleware\Grantless;
use SellingPartnerApi\Request;
use SellingPartnerApi\Seller\NotificationsV1\Responses\DeleteSubscriptionByIdResponse;

/**
 * deleteSubscriptionById
 */
class DeleteSubscriptionById extends Request
{
    protected Method $method = Method::DELETE;

    /**
     * @param  string  $subscriptionId  The identifier for the subscription that you want to delete.
     * @param  string  $notificationType  The type of notification.
     *
     *  For more information about notification types, refer to [Notification Type Values](https://developer-docs.amazon.com/sp-api/docs/notification-type-values).
     */
    public function __construct(
        protected string $subscriptionId,
        protected string $notificationType,
    ) {
        $this->middleware()->onRequest(new Grantless(GrantlessScope::NOTIFICATIONS));
    }

    public function resolveEndpoint(): string
    {
        return "/notifications/v1/subscriptions/{$this->notificationType}/{$this->subscriptionId}";
    }

    public function createDtoFromResponse(Response $response): DeleteSubscriptionByIdResponse
    {
        $status = $response->status();
        $responseCls = match ($status) {
            200, 400, 403, 404, 409, 413, 415, 429, 500, 503 => DeleteSubscriptionByIdResponse::class,
            default => throw new Exception("Unhandled response status: {$status}")
        };

        return $responseCls::deserialize($response->json(), $responseCls);
    }
}
