<?php

/**
 * This file is auto-generated by Saloon SDK Generator
 * Generator: SellingPartnerApi\Generator\Generators\RequestGenerator
 * Do not modify it directly.
 */

declare(strict_types=1);

namespace SellingPartnerApi\Seller\FBAInventoryV1\Requests;

use Exception;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Response;
use Saloon\Traits\Body\HasJsonBody;
use SellingPartnerApi\Request;
use SellingPartnerApi\Seller\FBAInventoryV1\Dto\CreateInventoryItemRequest;
use SellingPartnerApi\Seller\FBAInventoryV1\Responses\CreateInventoryItemResponse;

/**
 * createInventoryItem
 */
class CreateInventoryItem extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    /**
     * @param  CreateInventoryItemRequest  $createInventoryItemRequest  An item to be created in the inventory.
     */
    public function __construct(
        public CreateInventoryItemRequest $createInventoryItemRequest,
    ) {}

    public function resolveEndpoint(): string
    {
        return '/fba/inventory/v1/items';
    }

    public function createDtoFromResponse(Response $response): CreateInventoryItemResponse
    {
        $status = $response->status();
        $responseCls = match ($status) {
            200, 400, 403, 404, 429, 500, 503 => CreateInventoryItemResponse::class,
            default => throw new Exception("Unhandled response status: {$status}")
        };

        return $responseCls::deserialize($response->json(), $responseCls);
    }

    public function defaultBody(): array
    {
        return $this->createInventoryItemRequest->toArray();
    }
}
