<?php
/**
 * OfferProgramConfigurationPromotions
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Replenishment
 *
 * The Selling Partner API for Replenishment (Replenishment API) provides programmatic access to replenishment program metrics and offers. These programs provide recurring delivery (automatic or manual) of any replenishable item at a frequency chosen by the customer.
 *
 * The version of the OpenAPI document: 2022-11-07
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ReplenishmentV20221107;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * OfferProgramConfigurationPromotions Class Doc Comment
 *
 * @category Class
 * @description An object which represents all promotions applied to an offer.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class OfferProgramConfigurationPromotions extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OfferProgramConfigurationPromotions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'selling_partner_funded_base_discount' => '\SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding',
        'selling_partner_funded_tiered_discount' => '\SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding',
        'amazon_funded_base_discount' => '\SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding',
        'amazon_funded_tiered_discount' => '\SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'selling_partner_funded_base_discount' => null,
        'selling_partner_funded_tiered_discount' => null,
        'amazon_funded_base_discount' => null,
        'amazon_funded_tiered_discount' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'selling_partner_funded_base_discount' => 'sellingPartnerFundedBaseDiscount',
        'selling_partner_funded_tiered_discount' => 'sellingPartnerFundedTieredDiscount',
        'amazon_funded_base_discount' => 'amazonFundedBaseDiscount',
        'amazon_funded_tiered_discount' => 'amazonFundedTieredDiscount'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'selling_partner_funded_base_discount' => 'setSellingPartnerFundedBaseDiscount',
        'selling_partner_funded_tiered_discount' => 'setSellingPartnerFundedTieredDiscount',
        'amazon_funded_base_discount' => 'setAmazonFundedBaseDiscount',
        'amazon_funded_tiered_discount' => 'setAmazonFundedTieredDiscount'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'selling_partner_funded_base_discount' => 'getSellingPartnerFundedBaseDiscount',
        'selling_partner_funded_tiered_discount' => 'getSellingPartnerFundedTieredDiscount',
        'amazon_funded_base_discount' => 'getAmazonFundedBaseDiscount',
        'amazon_funded_tiered_discount' => 'getAmazonFundedTieredDiscount'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['selling_partner_funded_base_discount'] = $data['selling_partner_funded_base_discount'] ?? null;
        $this->container['selling_partner_funded_tiered_discount'] = $data['selling_partner_funded_tiered_discount'] ?? null;
        $this->container['amazon_funded_base_discount'] = $data['amazon_funded_base_discount'] ?? null;
        $this->container['amazon_funded_tiered_discount'] = $data['amazon_funded_tiered_discount'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets selling_partner_funded_base_discount
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding|null
     */
    public function getSellingPartnerFundedBaseDiscount()
    {
        return $this->container['selling_partner_funded_base_discount'];
    }

    /**
     * Sets selling_partner_funded_base_discount
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding|null $selling_partner_funded_base_discount selling_partner_funded_base_discount
     *
     * @return self
     */
    public function setSellingPartnerFundedBaseDiscount($selling_partner_funded_base_discount)
    {
        $this->container['selling_partner_funded_base_discount'] = $selling_partner_funded_base_discount;

        return $this;
    }
    /**
     * Gets selling_partner_funded_tiered_discount
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding|null
     */
    public function getSellingPartnerFundedTieredDiscount()
    {
        return $this->container['selling_partner_funded_tiered_discount'];
    }

    /**
     * Sets selling_partner_funded_tiered_discount
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding|null $selling_partner_funded_tiered_discount selling_partner_funded_tiered_discount
     *
     * @return self
     */
    public function setSellingPartnerFundedTieredDiscount($selling_partner_funded_tiered_discount)
    {
        $this->container['selling_partner_funded_tiered_discount'] = $selling_partner_funded_tiered_discount;

        return $this;
    }
    /**
     * Gets amazon_funded_base_discount
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding|null
     */
    public function getAmazonFundedBaseDiscount()
    {
        return $this->container['amazon_funded_base_discount'];
    }

    /**
     * Sets amazon_funded_base_discount
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding|null $amazon_funded_base_discount amazon_funded_base_discount
     *
     * @return self
     */
    public function setAmazonFundedBaseDiscount($amazon_funded_base_discount)
    {
        $this->container['amazon_funded_base_discount'] = $amazon_funded_base_discount;

        return $this;
    }
    /**
     * Gets amazon_funded_tiered_discount
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding|null
     */
    public function getAmazonFundedTieredDiscount()
    {
        return $this->container['amazon_funded_tiered_discount'];
    }

    /**
     * Sets amazon_funded_tiered_discount
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\OfferProgramConfigurationPromotionsDiscountFunding|null $amazon_funded_tiered_discount amazon_funded_tiered_discount
     *
     * @return self
     */
    public function setAmazonFundedTieredDiscount($amazon_funded_tiered_discount)
    {
        $this->container['amazon_funded_tiered_discount'] = $amazon_funded_tiered_discount;

        return $this;
    }
}


