<?php
/**
 * GetEligibleShipmentServicesRequest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Merchant Fulfillment
 *
 * The Selling Partner API for Merchant Fulfillment helps you build applications that let sellers purchase shipping for non-Prime and Prime orders using Amazon's Buy Shipping Services.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\MerchantFulfillmentV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * GetEligibleShipmentServicesRequest Class Doc Comment
 *
 * @category Class
 * @description Request schema.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class GetEligibleShipmentServicesRequest extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'GetEligibleShipmentServicesRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'shipment_request_details' => '\SellingPartnerApi\Model\MerchantFulfillmentV0\ShipmentRequestDetails',
        'shipping_offering_filter' => '\SellingPartnerApi\Model\MerchantFulfillmentV0\ShippingOfferingFilter'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'shipment_request_details' => null,
        'shipping_offering_filter' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shipment_request_details' => 'ShipmentRequestDetails',
        'shipping_offering_filter' => 'ShippingOfferingFilter'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'shipment_request_details' => 'setShipmentRequestDetails',
        'shipping_offering_filter' => 'setShippingOfferingFilter'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shipment_request_details' => 'getShipmentRequestDetails',
        'shipping_offering_filter' => 'getShippingOfferingFilter'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['shipment_request_details'] = $data['shipment_request_details'] ?? null;
        $this->container['shipping_offering_filter'] = $data['shipping_offering_filter'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['shipment_request_details'] === null) {
            $invalidProperties[] = "'shipment_request_details' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets shipment_request_details
     *
     * @return \SellingPartnerApi\Model\MerchantFulfillmentV0\ShipmentRequestDetails
     */
    public function getShipmentRequestDetails()
    {
        return $this->container['shipment_request_details'];
    }

    /**
     * Sets shipment_request_details
     *
     * @param \SellingPartnerApi\Model\MerchantFulfillmentV0\ShipmentRequestDetails $shipment_request_details shipment_request_details
     *
     * @return self
     */
    public function setShipmentRequestDetails($shipment_request_details)
    {
        $this->container['shipment_request_details'] = $shipment_request_details;

        return $this;
    }
    /**
     * Gets shipping_offering_filter
     *
     * @return \SellingPartnerApi\Model\MerchantFulfillmentV0\ShippingOfferingFilter|null
     */
    public function getShippingOfferingFilter()
    {
        return $this->container['shipping_offering_filter'];
    }

    /**
     * Sets shipping_offering_filter
     *
     * @param \SellingPartnerApi\Model\MerchantFulfillmentV0\ShippingOfferingFilter|null $shipping_offering_filter shipping_offering_filter
     *
     * @return self
     */
    public function setShippingOfferingFilter($shipping_offering_filter)
    {
        $this->container['shipping_offering_filter'] = $shipping_offering_filter;

        return $this;
    }
}


