<?php
/**
 * UpdateOrderApprovalsRequest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * UpdateOrderApprovalsRequest Class Doc Comment
 *
 * @category Class
 * @description The request body for the updateOrderItemsApprovals operation.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class UpdateOrderApprovalsRequest extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UpdateOrderApprovalsRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'approver' => 'string',
        'order_items_approval_requests' => '\SellingPartnerApi\Model\OrdersV0\OrderItemApprovalRequest[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'approver' => null,
        'order_items_approval_requests' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'approver' => 'Approver',
        'order_items_approval_requests' => 'OrderItemsApprovalRequests'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'approver' => 'setApprover',
        'order_items_approval_requests' => 'setOrderItemsApprovalRequests'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'approver' => 'getApprover',
        'order_items_approval_requests' => 'getOrderItemsApprovalRequests'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['approver'] = $data['approver'] ?? null;
        $this->container['order_items_approval_requests'] = $data['order_items_approval_requests'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['order_items_approval_requests'] === null) {
            $invalidProperties[] = "'order_items_approval_requests' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets approver
     *
     * @return string|null
     */
    public function getApprover()
    {
        return $this->container['approver'];
    }

    /**
     * Sets approver
     *
     * @param string|null $approver Person or system that triggers the approval actions on behalf of the actor.
     *
     * @return self
     */
    public function setApprover($approver)
    {
        $this->container['approver'] = $approver;

        return $this;
    }
    /**
     * Gets order_items_approval_requests
     *
     * @return \SellingPartnerApi\Model\OrdersV0\OrderItemApprovalRequest[]
     */
    public function getOrderItemsApprovalRequests()
    {
        return $this->container['order_items_approval_requests'];
    }

    /**
     * Sets order_items_approval_requests
     *
     * @param \SellingPartnerApi\Model\OrdersV0\OrderItemApprovalRequest[] $order_items_approval_requests A list of item approval requests.
     *
     * @return self
     */
    public function setOrderItemsApprovalRequests($order_items_approval_requests)
    {
        $this->container['order_items_approval_requests'] = $order_items_approval_requests;

        return $this;
    }
}


