<?php
/**
 * Item
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Easy Ship
 *
 * The Selling Partner API for Easy Ship helps you build applications that help sellers manage and ship Amazon Easy Ship orders. Your Easy Ship applications can: * Get available time slots for packages to be scheduled for delivery. * Schedule, reschedule, and cancel Easy Ship orders. * Print labels, invoices, and warranties. See the [Marketplace Support Table](https://developer-docs.amazon.com/sp-api/docs/easyship-api-v2022-03-23-use-case-guide#marketplace-support-table) for the differences in Easy Ship operations by marketplace.
 *
 * The version of the OpenAPI document: 2022-03-23
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\EasyShipV20220323;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * Item Class Doc Comment
 *
 * @category Class
 * @description Item identifier and serial number information.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Item extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Item';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_item_id' => 'string',
        'order_item_serial_numbers' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_item_id' => null,
        'order_item_serial_numbers' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_item_id' => 'orderItemId',
        'order_item_serial_numbers' => 'orderItemSerialNumbers'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_item_id' => 'setOrderItemId',
        'order_item_serial_numbers' => 'setOrderItemSerialNumbers'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_item_id' => 'getOrderItemId',
        'order_item_serial_numbers' => 'getOrderItemSerialNumbers'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['order_item_id'] = $data['order_item_id'] ?? null;
        $this->container['order_item_serial_numbers'] = $data['order_item_serial_numbers'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if (!is_null($this->container['order_item_id']) && (mb_strlen($this->container['order_item_id']) > 255)) {
            $invalidProperties[] = "invalid value for 'order_item_id', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['order_item_serial_numbers']) && (count($this->container['order_item_serial_numbers']) > 100)) {
            $invalidProperties[] = "invalid value for 'order_item_serial_numbers', number of items must be less than or equal to 100.";
        }

        return $invalidProperties;
    }


    /**
     * Gets order_item_id
     *
     * @return string|null
     */
    public function getOrderItemId()
    {
        return $this->container['order_item_id'];
    }

    /**
     * Sets order_item_id
     *
     * @param string|null $order_item_id The Amazon-defined order item identifier.
     *
     * @return self
     */
    public function setOrderItemId($order_item_id)
    {
        if (!is_null($order_item_id) && (mb_strlen($order_item_id) > 255)) {
            throw new \InvalidArgumentException('invalid length for $order_item_id when calling Item., must be smaller than or equal to 255.');
        }

        $this->container['order_item_id'] = $order_item_id;

        return $this;
    }
    /**
     * Gets order_item_serial_numbers
     *
     * @return string[]|null
     */
    public function getOrderItemSerialNumbers()
    {
        return $this->container['order_item_serial_numbers'];
    }

    /**
     * Sets order_item_serial_numbers
     *
     * @param string[]|null $order_item_serial_numbers A list of serial numbers for the items associated with the `OrderItemId` value.
     *
     * @return self
     */
    public function setOrderItemSerialNumbers($order_item_serial_numbers)
    {

        if (!is_null($order_item_serial_numbers) && (count($order_item_serial_numbers) > 100)) {
            throw new \InvalidArgumentException('invalid value for $order_item_serial_numbers when calling Item., number of items must be less than or equal to 100.');
        }
        $this->container['order_item_serial_numbers'] = $order_item_serial_numbers;

        return $this;
    }
}


