<?php
/**
 * ShipmentMeasurements
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Retail Procurement Shipments
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\VendorShipping;

use \ArrayAccess;
use \SellingPartnerApi\ObjectSerializer;
use \SellingPartnerApi\Model\ModelInterface;

/**
 * ShipmentMeasurements Class Doc Comment
 *
 * @category Class
 * @description Shipment measurement details.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ShipmentMeasurements implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ShipmentMeasurements';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'gross_shipment_weight' => '\SellingPartnerApi\Model\VendorShipping\Weight',
        'shipment_volume' => '\SellingPartnerApi\Model\VendorShipping\Volume',
        'carton_count' => 'int',
        'pallet_count' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'gross_shipment_weight' => null,
        'shipment_volume' => null,
        'carton_count' => null,
        'pallet_count' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'gross_shipment_weight' => 'grossShipmentWeight',
        'shipment_volume' => 'shipmentVolume',
        'carton_count' => 'cartonCount',
        'pallet_count' => 'palletCount'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'gross_shipment_weight' => 'setGrossShipmentWeight',
        'shipment_volume' => 'setShipmentVolume',
        'carton_count' => 'setCartonCount',
        'pallet_count' => 'setPalletCount',
        'headers' => 'setHeaders'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'gross_shipment_weight' => 'getGrossShipmentWeight',
        'shipment_volume' => 'getShipmentVolume',
        'carton_count' => 'getCartonCount',
        'pallet_count' => 'getPalletCount',
        'headers' => 'getHeaders'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['gross_shipment_weight'] = $data['gross_shipment_weight'] ?? null;
        $this->container['shipment_volume'] = $data['shipment_volume'] ?? null;
        $this->container['carton_count'] = $data['carton_count'] ?? null;
        $this->container['pallet_count'] = $data['pallet_count'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }

    /**
     * Gets headers, if this is a top-level response model
     *
     * @return array[string]|null
     */
    public function getHeaders()
    {
        return $this->container['headers'];
    }

    /**
     * Sets headers (only relevant to response models)
     *
     * @param array[string => string]|null $headers Associative array of response headers.
     *
     * @return self
     */
    public function setHeaders($headers)
    {
        $this->container['headers'] = $headers;

        return $this;
    }


    /**
     * Gets gross_shipment_weight
     *
     * @return \SellingPartnerApi\Model\VendorShipping\Weight|null
     */
    public function getGrossShipmentWeight()
    {
        return $this->container['gross_shipment_weight'];
    }

    /**
     * Sets gross_shipment_weight
     *
     * @param \SellingPartnerApi\Model\VendorShipping\Weight|null $gross_shipment_weight gross_shipment_weight
     *
     * @return self
     */
    public function setGrossShipmentWeight($gross_shipment_weight)
    {
        $this->container['gross_shipment_weight'] = $gross_shipment_weight;

        return $this;
    }

    /**
     * Gets shipment_volume
     *
     * @return \SellingPartnerApi\Model\VendorShipping\Volume|null
     */
    public function getShipmentVolume()
    {
        return $this->container['shipment_volume'];
    }

    /**
     * Sets shipment_volume
     *
     * @param \SellingPartnerApi\Model\VendorShipping\Volume|null $shipment_volume shipment_volume
     *
     * @return self
     */
    public function setShipmentVolume($shipment_volume)
    {
        $this->container['shipment_volume'] = $shipment_volume;

        return $this;
    }

    /**
     * Gets carton_count
     *
     * @return int|null
     */
    public function getCartonCount()
    {
        return $this->container['carton_count'];
    }

    /**
     * Sets carton_count
     *
     * @param int|null $carton_count Number of cartons present in the shipment. Provide the cartonCount only for unpalletized shipments.
     *
     * @return self
     */
    public function setCartonCount($carton_count)
    {
        $this->container['carton_count'] = $carton_count;

        return $this;
    }

    /**
     * Gets pallet_count
     *
     * @return int|null
     */
    public function getPalletCount()
    {
        return $this->container['pallet_count'];
    }

    /**
     * Sets pallet_count
     *
     * @param int|null $pallet_count Number of pallets present in the shipment. Provide the palletCount only for palletized shipments.
     *
     * @return self
     */
    public function setPalletCount($pallet_count)
    {
        $this->container['pallet_count'] = $pallet_count;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


