<?php
/**
 * CreditNoteDetails
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Retail Procurement Payments
 *
 * The Selling Partner API for Retail Procurement Payments provides programmatic access to vendors payments data.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\VendorInvoicesV1;

use \ArrayAccess;
use \SellingPartnerApi\ObjectSerializer;
use \SellingPartnerApi\Model\ModelInterface;

/**
 * CreditNoteDetails Class Doc Comment
 *
 * @category Class
 * @description References required in order to process a credit note. This information is required only if InvoiceType is CreditNote.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class CreditNoteDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreditNoteDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'reference_invoice_number' => 'string',
        'debit_note_number' => 'string',
        'returns_reference_number' => 'string',
        'goods_return_date' => 'string',
        'rma_id' => 'string',
        'coop_reference_number' => 'string',
        'consignors_reference_number' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'reference_invoice_number' => null,
        'debit_note_number' => null,
        'returns_reference_number' => null,
        'goods_return_date' => null,
        'rma_id' => null,
        'coop_reference_number' => null,
        'consignors_reference_number' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'reference_invoice_number' => 'referenceInvoiceNumber',
        'debit_note_number' => 'debitNoteNumber',
        'returns_reference_number' => 'returnsReferenceNumber',
        'goods_return_date' => 'goodsReturnDate',
        'rma_id' => 'rmaId',
        'coop_reference_number' => 'coopReferenceNumber',
        'consignors_reference_number' => 'consignorsReferenceNumber'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'reference_invoice_number' => 'setReferenceInvoiceNumber',
        'debit_note_number' => 'setDebitNoteNumber',
        'returns_reference_number' => 'setReturnsReferenceNumber',
        'goods_return_date' => 'setGoodsReturnDate',
        'rma_id' => 'setRmaId',
        'coop_reference_number' => 'setCoopReferenceNumber',
        'consignors_reference_number' => 'setConsignorsReferenceNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'reference_invoice_number' => 'getReferenceInvoiceNumber',
        'debit_note_number' => 'getDebitNoteNumber',
        'returns_reference_number' => 'getReturnsReferenceNumber',
        'goods_return_date' => 'getGoodsReturnDate',
        'rma_id' => 'getRmaId',
        'coop_reference_number' => 'getCoopReferenceNumber',
        'consignors_reference_number' => 'getConsignorsReferenceNumber'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['reference_invoice_number'] = $data['reference_invoice_number'] ?? null;
        $this->container['debit_note_number'] = $data['debit_note_number'] ?? null;
        $this->container['returns_reference_number'] = $data['returns_reference_number'] ?? null;
        $this->container['goods_return_date'] = $data['goods_return_date'] ?? null;
        $this->container['rma_id'] = $data['rma_id'] ?? null;
        $this->container['coop_reference_number'] = $data['coop_reference_number'] ?? null;
        $this->container['consignors_reference_number'] = $data['consignors_reference_number'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets reference_invoice_number
     *
     * @return string|null
     */
    public function getReferenceInvoiceNumber()
    {
        return $this->container['reference_invoice_number'];
    }

    /**
     * Sets reference_invoice_number
     *
     * @param string|null $reference_invoice_number Original Invoice Number when sending a credit note relating to an existing invoice. One Invoice only to be processed per Credit Note. This is mandatory for AP Credit Notes.
     *
     * @return self
     */
    public function setReferenceInvoiceNumber($reference_invoice_number)
    {
        $this->container['reference_invoice_number'] = $reference_invoice_number;

        return $this;
    }
    /**
     * Gets debit_note_number
     *
     * @return string|null
     */
    public function getDebitNoteNumber()
    {
        return $this->container['debit_note_number'];
    }

    /**
     * Sets debit_note_number
     *
     * @param string|null $debit_note_number Debit Note Number as generated by Amazon. Recommended for Returns and COOP Credit Notes.
     *
     * @return self
     */
    public function setDebitNoteNumber($debit_note_number)
    {
        $this->container['debit_note_number'] = $debit_note_number;

        return $this;
    }
    /**
     * Gets returns_reference_number
     *
     * @return string|null
     */
    public function getReturnsReferenceNumber()
    {
        return $this->container['returns_reference_number'];
    }

    /**
     * Sets returns_reference_number
     *
     * @param string|null $returns_reference_number Identifies the Returns Notice Number. Mandatory for all Returns Credit Notes.
     *
     * @return self
     */
    public function setReturnsReferenceNumber($returns_reference_number)
    {
        $this->container['returns_reference_number'] = $returns_reference_number;

        return $this;
    }
    /**
     * Gets goods_return_date
     *
     * @return string|null
     */
    public function getGoodsReturnDate()
    {
        return $this->container['goods_return_date'];
    }

    /**
     * Sets goods_return_date
     *
     * @param string|null $goods_return_date Defines a date and time according to ISO8601.
     *
     * @return self
     */
    public function setGoodsReturnDate($goods_return_date)
    {
        $this->container['goods_return_date'] = $goods_return_date;

        return $this;
    }
    /**
     * Gets rma_id
     *
     * @return string|null
     */
    public function getRmaId()
    {
        return $this->container['rma_id'];
    }

    /**
     * Sets rma_id
     *
     * @param string|null $rma_id Identifies the Returned Merchandise Authorization ID, if generated.
     *
     * @return self
     */
    public function setRmaId($rma_id)
    {
        $this->container['rma_id'] = $rma_id;

        return $this;
    }
    /**
     * Gets coop_reference_number
     *
     * @return string|null
     */
    public function getCoopReferenceNumber()
    {
        return $this->container['coop_reference_number'];
    }

    /**
     * Sets coop_reference_number
     *
     * @param string|null $coop_reference_number Identifies the COOP reference used for COOP agreement. Failure to provide the COOP reference number or the Debit Note number may lead to a rejection of the Credit Note.
     *
     * @return self
     */
    public function setCoopReferenceNumber($coop_reference_number)
    {
        $this->container['coop_reference_number'] = $coop_reference_number;

        return $this;
    }
    /**
     * Gets consignors_reference_number
     *
     * @return string|null
     */
    public function getConsignorsReferenceNumber()
    {
        return $this->container['consignors_reference_number'];
    }

    /**
     * Sets consignors_reference_number
     *
     * @param string|null $consignors_reference_number Identifies the consignor reference number (VRET number), if generated by Amazon.
     *
     * @return self
     */
    public function setConsignorsReferenceNumber($consignors_reference_number)
    {
        $this->container['consignors_reference_number'] = $consignors_reference_number;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


